library RSCOM;
{RSCOM.DLL  B.Kainka 2001, update 2/2003, COM10..99 9/2008}

uses Windows,
  SysUtils,
  Classes;
var  SaveExit: Pointer;
     PortHandle: THandle;
     StartTime: Int64;
     TimeUnit: Real = 0.000838;

procedure TIMEOUTS (TOut: Integer); stdcall;
var TimeOut:TCOMMTIMEOUTS;
begin
   TimeOut.ReadIntervalTimeout:=1;
   TimeOut.ReadTotalTimeoutMultiplier:=1;
   TimeOut.ReadTotalTimeoutConstant:=TOut;
   TimeOut.WriteTotalTimeoutMultiplier:=10;
   TimeOut.WriteTotalTimeoutConstant:=TOut;
   SetCommTimeouts(PortHandle,TimeOut);
end;

function OPENCOM (OpenString: pchar): Integer; stdcall;
var S, OpenStr, PortStr, Parameter :String;
    DCB: TDCB;
begin
   Result := 0;
   if PortHandle > 0 then CloseHandle(PortHandle);
   OpenStr := OpenString;
   S := copy (OpenStr,5,1);
   if S=':' then begin        //COM1:
      PortStr := copy (OpenStr,1,4);
      Parameter:= copy (OpenStr,6,Length(OpenStr)-6);
   end;
   S := copy (OpenStr,6,1);
   if S=':' then begin        //COM10:
      PortStr := copy (OpenStr,1,5);
      PortStr := '\\.\' + PortStr;
      Parameter:= copy (OpenStr,7,Length(OpenStr)-7);
   end;
   S := copy (OpenStr,7,1);
   if S=':' then begin         //COM100:
      PortStr := copy (OpenStr,1,6);
      PortStr := '\\.\' + PortStr;
      Parameter:= copy (OpenStr,8,Length(OpenStr)-8);
   end;
   PortHandle:=CreateFile(PChar(PortStr),GENERIC_READ or GENERIC_WRITE,0,NIL,OPEN_EXISTING,0,0);
   GetCommState(PortHandle,DCB);
   BuildCommDCB(PChar(Parameter),dcb);
   DCB.Flags := 1;
   if SetCommState(PortHandle,DCB)then Result := 1;
   TimeOuts (300);
end;

Procedure BUFFERSIZE (Size: DWORD); stdcall;
begin
   SetupComm(PortHandle,Size,Size);
end;

procedure CLOSECOM(); stdcall;
begin
    CloseHandle(PortHandle);
    PortHandle:= 0;
end;

procedure SENDBYTE (Dat: Integer); stdcall;
var BytesWritten: DWord;
begin
 WriteFile(PortHandle,Dat,1,BytesWritten,NIL);
END;

function READBYTE(): Integer; stdcall;
var Dat: Byte;
    BytesRead: DWORD;
begin
 ReadFile(PortHandle,Dat,1,BytesRead,NIL);
 if BytesRead = 1 then Result:=Dat else Result := -1;
end;

procedure SENDSTRING (Buffer: Pchar); stdcall;
var BytesWritten: DWord;
begin
  WriteFile(PortHandle,Buffer^,Length(Buffer),BytesWritten,NIL);
END;

function READSTRING(): Pchar; stdcall;
var Dat: Integer;
    Data: STRING;
begin
  Dat := 0;
  while ((Dat > -1) and (Dat <> 13)) do begin
    Dat := ReadByte();
    if ((Dat > -1) and (Dat <> 13)) then Data := Data + Chr(Dat);
  end;
  READSTRING := Pchar(Data);
end;

procedure CLEARBUFFER (); stdcall;
begin
  PurgeComm(PortHandle,PURGE_TXCLEAR);
  PurgeComm(PortHandle,PURGE_RXCLEAR);
end;

function INBUFFER (): DWORD; stdcall;
var Comstat: _Comstat;
    Errors: DWORD;
begin
  if ClearCommError (PortHandle, Errors, @Comstat) then
  INBUFFER := Comstat.cbInQue else INBUFFER := 0;
end;

function OUTBUFFER (): DWORD; stdcall;
var Comstat: _Comstat;
    Errors: DWORD;
begin
  if ClearCommError (PortHandle, Errors, @Comstat) then
  OUTBUFFER := Comstat.cbOutQue else OUTBUFFER := 0;
end;

procedure DTR(State:Integer); stdcall;
begin
 if (State=0) then EscapeCommFunction(PortHandle,CLRDTR)
 else EscapeCommFunction(PortHandle,SETDTR);
end;

procedure RTS(State:Integer); stdcall;
begin
 if (State=0) then EscapeCommFunction(PortHandle,CLRRTS)
 else EscapeCommFunction(PortHandle,SETRTS);
end;

procedure TXD(State:integer); stdcall;
begin
 if (State=0) then EscapeCommFunction(PortHandle,CLRBREAK)
 else EscapeCommFunction(PortHandle,SETBREAK);
end;

function CTS():Integer; stdcall;
Var mask:Dword;
begin
     GetCommModemStatus(PortHandle,mask);
     if (mask and MS_CTS_ON)=0 then result:=0 else result:=1;
end;

function DSR():Integer; stdcall;
Var mask:Dword;
begin
     GetCommModemStatus(PortHandle,mask);
     if (mask and MS_DSR_ON)=0 then result:=0 else result:=1;
end;

function RI():Integer; stdcall;
Var mask:Dword;
begin
     GetCommModemStatus(PortHandle,mask);
     if (mask and MS_RING_ON)=0 then result:=0 else result:=1;
end;

function DCD():Integer; stdcall;
Var mask:Dword;
begin
     GetCommModemStatus(PortHandle,mask);
     if (mask and MS_RLSD_ON)=0 then result:=0 else result:=1;
end;

function INPUTS():Integer; stdcall;
Var mask:Dword;
begin
     GetCommModemStatus(PortHandle,mask);
     INPUTS := (mask div 16) and 15;
end;

procedure TIMEINIT(); stdcall;
var f: Int64;
begin
  QueryPerformanceFrequency(f);
  TimeUnit := 1000 / f;
  QueryPerformanceCounter(StartTime)
end;

function TIMEREAD(): Real; stdcall;
var t: Int64;
begin
  QueryPerformanceCounter(t);
  TIMEREAD := TimeUnit*(t - StartTime) ;
end;

procedure DELAY(DelayTime: Real); stdcall;
var TimeStart: real;
begin
  TimeStart := TIMEREAD;
  while TIMEREAD < (TimeStart + DelayTime) do;
end;

procedure REALTIME(); stdcall;
begin
 SetPriorityClass (GetCurrentProcess(), REALTIME_PRIORITY_CLASS);
end;

procedure NORMALTIME(); stdcall;
begin
  SetPriorityClass (GetCurrentProcess(), NORMAL_PRIORITY_CLASS);
end;


procedure LibExit;
begin
  if PortHandle> 0 then Closecom;
  ExitProc := SaveExit;
end;

procedure LibraryProc(Reason: Integer);
begin
 if (Reason = DLL_PROCESS_DETACH) then
 if (PortHandle> 0) then Closecom;
end;

exports
  OPENCOM index 1,
  TIMEOUTS index 2,
  BUFFERSIZE index 3,
  CLOSECOM index 4,
  SENDBYTE index 5,
  READBYTE index 6,
  SENDSTRING index 7,
  READSTRING index 8,
  CLEARBUFFER index 9,
  INBUFFER index 10,
  OUTBUFFER index 11,
  DTR index 12,
  RTS index 13,
  TXD index 14,
  CTS index 15,
  DSR index 16,
  RI  index 17,
  DCD index 18,
  INPUTS index 19,
  TIMEINIT index 20,
  TIMEREAD index 21,
  DELAY index 22,
  REALTIME index 23,
  NORMALTIME index 24;

begin
  SaveExit := ExitProc;
  ExitProc := @LibExit;
  DLLProc := @LibraryProc;
end.

