; ******************************************************************************
; Module: LCD_INIT.asm
; Created: 15.06.2002
; Function: Basic I/O routines for Output on LCD
;           - Initialize basic Input/Output
;           - Busy routine
;           - Set cursor to line 
;
; 
; ************************* Copyright by Stefan Kneip **************************
#include <sfr51.inc>                            ; include SFR definitions (located in include directory)

lcd_init        segment code

public  lcd_init
public  lcd_cursor
public  lcd_busy
public  lcd_shift_left
public  lcd_shift_right

extern  code            delay_loop
extern  xdata           line_nr

extern  code            LCD_CHAR

public  LCD_CMD_WRITE
public  LCD_CMD_READ
public  LCD_DATA_WRITE
public  LCD_DATA_READ

LCD_CMD_WRITE   EQU     8000H                   ; LCD address write command
LCD_CMD_READ    EQU     8001H                   ; LCD address read command
LCD_DATA_WRITE  EQU     8002H                   ; LCD address write data
LCD_DATA_READ   EQU     8000H                   ; LCD address read data


                rseg    lcd_init

lcd_init:                                       ; initialize LCD    
                ACALL   lcd_busy                ; is LCD busy?
                MOV     DPTR,#LCD_CMD_WRITE     ; write address to data pointer 
                MOV     A,#00111000B            ; initialize 8 bit data (bit4=1), 2 lines(bit3=1)
                MOVX    @DPTR,A                 ; write function-set to command_write
                ACALL   lcd_busy                ; is LCD busy?    
                MOV     DPTR,#LCD_CMD_WRITE     ; write address to data pointer
                MOV     A,#00001100B            ; display on (bit2=1), cursor off(bit1=0), blinking off (bit0=0)
                MOVX    @DPTR,A                 ; write Display ON/OFF control to command_write
                ACALL   lcd_busy                ; is LCD busy?
                MOV     DPTR,#LCD_CMD_WRITE     ; write address to data pointer
                MOV     A,#00000001B            ; clear display
                MOVX    @DPTR,A                 ; write clear display to command_write
                RET                             ; end of lcd_init
              
lcd_cursor:                                     ; set cursor to line 
                                                ; Cursor positions:
                                                ; line_nr=0 > 00H = 10000000B
                                                ; line_nr=1 > 40H = 11000000B
                                                ; line_nr=2 > 14H = 10010100B
                                                ; line_nr=3 > 54H = 11010100B
                                                ;
                ACALL   lcd_busy                ; is LCD busy?
                MOV     DPTR,#line_nr           ; line_nr ..
                MOVX    A,@DPTR                 ; .. to ACC
                MOV     DPTR,#LCD_CMD_WRITE     ; write address to data pointer
                CJNE    A,#00, lcd_cursor_line2
                MOV     A,#10000000B            ; line 1 pos 1 (0x00)
                SJMP    lcd_cursor_set
          lcd_cursor_line2:
                CJNE    A,#01, lcd_cursor_line3
                MOV     A,#11000000B            ; line 2 pos 1 (0x40)
                SJMP    lcd_cursor_set
          lcd_cursor_line3:
                CJNE    A,#02, lcd_cursor_line4
                MOV     A,#10010100B            ; line 3 pos 1 (0x14)
                SJMP    lcd_cursor_set
          lcd_cursor_line4:      
                MOV     A,#11010100B            ; line 4 pos 1 (0x54)
          lcd_cursor_set:      
                MOVX    @DPTR,A                 ; write cursor position to command_write
                RET                             

lcd_shift_right:                                ; scroll display right
                ACALL   lcd_busy                ; is LCD busy?
                MOV     R0,#LCD_CHAR            ; 
       lcd_shiftright_loop:       
                MOV     DPTR,#LCD_CMD_WRITE     ; write address to data pointer
                MOV     A,#00011100B            ; Display shift right
                MOVX    @DPTR,A                 ; write display shift to command_write
                ACALL   delay_loop
                DJNZ    R0, lcd_shiftright_loop
                RET

lcd_shift_left:                                 ; scroll display left
                ACALL   lcd_busy                ; is LCD busy?
                MOV     R0,#LCD_CHAR            ; 
       lcd_shiftleft_loop:       
                MOV     DPTR,#LCD_CMD_WRITE     ; write address to data pointer
                MOV     A,#00011000B            ; Display shift left
                MOVX    @DPTR,A                 ; write display shift to command_write
                ACALL   delay_loop
                DJNZ    R0, lcd_shiftleft_loop
                RET

lcd_busy:                                       ; check if LCD controller is busy
                MOV     DPTR, #LCD_CMD_READ     ; load_address to data pointer
                MOVX    A, @DPTR                ; command_read to ACC
                JB      ACC.7, lcd_busy         ; busy-flag set?
                RET                             ; if not, then back...

                END
