; ******************************************************************************
; Module: LCD_MAIN.asm
; Created: 15.06.2002
; Function: Main program code 
;
; 
; ************************* Copyright by Stefan Kneip **************************

#include <sfr51.inc>                            ; include SFR definitions (located in include directory)

lcd_main        segment code

text_adr        segment xdata                   ; global variable
line_nr         segment xdata                   ; global variable

extern  code    lcd_init
extern  code    delay_loop
extern  code    lcd_text_transfer
extern  code    lcd_shift_right
extern  code    lcd_shift_left

extern  code    lcd_text1
extern  code    lcd_text2
extern  code    lcd_text3
extern  code    lcd_text4

extern  xdata   text_adr
extern  xdata   line_nr

public          LCD_DELAY   
public          LCD_CHAR                        

LCD_DELAY       EQU     0050H                   ; COUNTER PRESET FOR DELAY LOOP
LCD_CHAR        EQU     0014H                   ; NO OF CHAR OF EACH LINE OF LCD

public          _main


                cseg at 0
                LJMP    _main
                end
                
                rseg    lcd_main
               
_main:                                           ; main program
                
                ACALL   lcd_init                ; initialize LCD
                ACALL   delay_loop              ; wait a while ...
                MOV     dptr,#lcd_text1         ; save address of lcd_text1 to .. 
                MOV     a,DPL                   ; ...
                MOV     b,DPH                   ; ...
                MOV     dptr,#text_adr          ; ... 
                MOVX    @DPTR,a                 ; ...
                INC     DPTR                    ; ...
                MOV     a,b                     ; ...
                MOVX    @DPTR,a                 ; .. global variable text_adr

                MOV     dptr,#line_nr           ; save line number (0) to ... 
                MOV     a,#00H                  ; ... 
                MOVX    @dptr,a                 ; .. global variable line_nr
                ACALL   lcd_text_transfer       ; transfer text to LCD
                
                MOV     dptr,#lcd_text2         ; save address of lcd_text1 to .. 
                MOV     a,DPL                   ; ...
                MOV     b,DPH                   ; ...
                MOV     dptr,#text_adr          ; ... 
                MOVX    @DPTR,a                 ; ...
                INC     DPTR                    ; ...
                MOV     a,b                     ; ...
                MOVX    @DPTR,a                 ; .. global variable text_adr

                MOV     dptr,#line_nr           ; save line number (1) to ... 
                MOV     a,#01H                  ; ... 
                MOVX    @dptr,a                 ; .. global variable line_nr
                ACALL   lcd_text_transfer       ; transfer text to LCD

                MOV     dptr,#lcd_text3         ; save address of lcd_text1 to .. 
                MOV     a,DPL                   ; ...
                MOV     b,DPH                   ; ...
                MOV     dptr,#text_adr          ; ... 
                MOVX    @DPTR,a                 ; ...
                INC     DPTR                    ; ...
                MOV     a,b                     ; ...
                MOVX    @DPTR,a                 ; .. global variable text_adr

                MOV     dptr,#line_nr           ; save line number (2) to ... 
                MOV     a,#02H                  ; ... 
                MOVX    @dptr,a                 ; .. global variable line_nr
                ACALL   lcd_text_transfer       ; transfer text to LCD
                
                MOV     dptr,#lcd_text4         ; save address of lcd_text3 to .. 
                MOV     a,DPL                   ; ...
                MOV     b,DPH                   ; ...
                MOV     dptr,#text_adr          ; ... 
                MOVX    @DPTR,a                 ; ...
                INC     DPTR                    ; ...
                MOV     a,b                     ; ...
                MOVX    @DPTR,a                 ; .. global variable text_adr

                MOV     dptr,#line_nr           ; save line number (3) to ... 
                MOV     a,#03H                  ; ... 
                MOVX    @dptr,a                 ; .. global variable line_nr
                ACALL   lcd_text_transfer       ; transfer text to LCD
                
                ACALL   delay_loop
                ACALL   lcd_shift_right
                ACALL   delay_loop
                ACALL   delay_loop
                ACALL   lcd_shift_left
                
loop:                                           ; endless loop
                sjmp    loop    


              
                END

