; ******************************************************************************
; Module: LCD_OUTPUT.asm
; Created: 15.06.2002
; Function: Output of text to LCD
;          
; 
; ************************* Copyright by Stefan Kneip **************************
#include <sfr51.inc>                            ; include SFR definitions (located in include directory)

lcd_output      segment code

text_nr         segment xdata                   ; global variable
line_nr         segment xdata                   ; global variable

public                  lcd_text_transfer
extern  code            lcd_busy
extern  code            lcd_cursor
extern  code            delay_loop
    
extern  xdata           LCD_DATA_WRITE

extern  xdata           text_adr
extern  xdata           line_nr

                rseg    lcd_output

lcd_text_transfer:                              ; output text onto LCD
                                                
                ACALL   lcd_cursor              ; set cursor to line given in @#line_nr 
                ACALL   lcd_busy                ; is LCD busy?
                MOV     R0,#00H                 ; initialize counter 
                MOV     R1,#00H                 ; initialize counter
                MOV     DPTR, #text_adr         ; load text_adr to data pointer
                MOVX    A,@DPTR                 ; low_byte
                MOV     B,A                     ; low_byte in B
                INC     DPTR
                MOVX    A,@DPTR                 ; high_byte
                MOV     DPH,A
                MOV     A,B
                MOV     DPL,A

        lcd_text_loop:     
                CLR     A                       ; ACC=0
                MOVC    A,@A+DPTR               ; load byte from RAM to ACC
                JZ      lcd_text_transfer_end   ; if byte=0 then end of transfer
                INC     R0                      ; counter 
                INC     R1                      ; counter
                MOV     DPTR,#LCD_DATA_WRITE    ; write_address to data pointer
                MOVX    @DPTR,A                 ; store ACC to LCD
                MOV     DPTR, #text_adr
                MOVX    A,@DPTR                 ; low_byte
                MOV     B,A                     ; low_byte in B
                INC     DPTR
                MOVX    A,@DPTR                 ; high_byte
                MOV     DPH,A
                MOV     A,B
                MOV     DPL,A
        lcd_text_loop1:        
                INC     DPTR                    ; increase data pointer as indicated ...
                DJNZ    R0, lcd_text_loop1      ; ... by the counter
                MOV     A,R1                    ;
                MOV     R0,A                    ; restore counter R0
                ACALL   delay_loop              ; wait a while ...
                SJMP    lcd_text_loop           ; and jump back to get the next char
        lcd_text_transfer_end:                  ; end of text reached ...    
                RET                             ; ... then back
                
                END

