'Bascom ATmega88, Timer

$regfile = "m88def.dat"
$crystal = 16000000
Baud = 115200



Open "com1:" For Binary As #1

Dim D As Byte
Dim B As Byte
Dim Ticks As Byte
Dim Ram(504) As Byte
Dim Adr As Word
Dim Command As Byte
Dim Oneshot As Byte
Dim Timebase As Integer
Dim Channels As Byte
Dim Trigger As Byte
Dim Triggerlevel As Byte
Dim Triggertimeout As Word
Dim Saveram As Byte
Dim Hi As Byte
Dim Lo As Byte




Config Timer2 = Pwm , Prescale = 32 , Compare B Pwm = Clear Down
'1kHz at PD3
Start Timer2
Ocr2b = 128

Portc = 255                                                 'Pullups

Config Timer1 = Timer , Prescale = 8
Stop Timer1
On Ovf1 Tim1_isr
Enable Timer1
Enable Interrupts


Config Timer0 = Timer , Prescale = 1
Stop Timer0
On Ovf0 Tim0_isr
Enable Timer0

Config Portb = Output

Timebase = -40
Oneshot = 1
Channels = 1
Trigger = 0
Saveram = 1

Do
  Get #1 , Command
  If Command = 1 Then
     Oneshot = 1
     Adr = 1
     Saveram = 1
     Start Timer1
  End If
  If Command = 2 Then
     Adr = 1
     Trigger = 1
     Triggertimeout = 0
     Start Timer0
  End If
  If Command = 3 Then
     Adr = 1
     Trigger = 2
     Triggertimeout = 0
     Start Timer0
  End If
  If Command = 10 Then
     Get #1 , Hi
     Get #1 , Lo
     Timebase = 256 * Hi
     Timebase = Timebase + Lo
     Timebase = Timebase - 10
     Timebase = 0 - Timebase
  End If
  If Command = 20 Then
     Get #1 , B
     Channels = B
  End If
  If Command = 30 Then
     Get #1 , B
     Triggerlevel = B
  End If


Loop



Tim1_isr:
  If Timebase > -30 Then
    For Adr = 0 To 501
       D = Pinc
       Ram(adr) = D
    Next Adr
  Else
  Timer1 = Timebase
  Portb.0 = 1
  D = Pinc
  If Saveram = 1 Then
     Ram(adr) = D
     Adr = Adr + 1
  Else
     Put #1 , D
  End If
  End If

  If Adr > 501 Then
    For Adr = 1 To 501
      D = Ram(adr)
      Put #1 , D
    Next Adr
    Adr = 1
    If Oneshot = 1 Then
       Stop Timer1
    End If
  End If
  Portb.0 = 0
Return

Tim0_isr:
  D = Pinc
  If Trigger = 1 Then
     If D < Triggerlevel Then Trigger = 11
  End If
  If Trigger = 11 Then
    If D >= Triggerlevel Then
      Stop Timer0
      Timer1 = -1
      Start Timer1
    End If
  End If
  If Trigger = 2 Then
    If D >= Triggerlevel Then Trigger = 12
  End If
  If Trigger = 12 Then
    If D < Triggerlevel Then
      Stop Timer0
      Timer1 = -1
      Start Timer1
    End If
  End If
  Triggertimeout = Triggertimeout + 1
  If Triggertimeout > 5000 Then
      Stop Timer0
      Timer1 = -1
      Start Timer1
  End If
Return



End