VERSION 5.00
Begin VB.Form UniScope 
   Caption         =   "ATM18 Logic Analyzer"
   ClientHeight    =   6495
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   8190
   LinkTopic       =   "Form1"
   ScaleHeight     =   433
   ScaleMode       =   0  'Benutzerdefiniert
   ScaleWidth      =   473.99
   StartUpPosition =   3  'Windows-Standard
   Begin VB.HScrollBar HScroll1 
      Height          =   255
      LargeChange     =   10
      Left            =   240
      Max             =   500
      TabIndex        =   19
      Top             =   4440
      Width           =   7695
   End
   Begin VB.OptionButton Option6 
      Caption         =   "10 ms/div"
      Height          =   375
      Left            =   6360
      TabIndex        =   18
      Top             =   4800
      Width           =   1215
   End
   Begin VB.OptionButton Option5 
      Caption         =   "5 ms/div"
      Height          =   375
      Left            =   5040
      TabIndex        =   17
      Top             =   4800
      Width           =   1215
   End
   Begin VB.OptionButton Option4 
      Caption         =   "2 ms/div"
      Height          =   375
      Left            =   3840
      TabIndex        =   16
      Top             =   4800
      Width           =   1215
   End
   Begin VB.OptionButton Option3 
      Caption         =   "1 ms/div"
      Height          =   375
      Left            =   2640
      TabIndex        =   15
      Top             =   4800
      Value           =   -1  'True
      Width           =   1215
   End
   Begin VB.OptionButton Option2 
      Caption         =   "500 s/div"
      Height          =   375
      Left            =   1440
      TabIndex        =   14
      Top             =   4800
      Width           =   1215
   End
   Begin VB.OptionButton Option1 
      Caption         =   "200 s/div"
      Height          =   375
      Left            =   240
      TabIndex        =   13
      Top             =   4800
      Width           =   1215
   End
   Begin VB.CheckBox Check6 
      Caption         =   "C0"
      Height          =   255
      Left            =   7440
      TabIndex        =   12
      Top             =   5280
      Width           =   615
   End
   Begin VB.CheckBox Check5 
      Caption         =   "C1"
      Height          =   255
      Left            =   6600
      TabIndex        =   11
      Top             =   5280
      Width           =   615
   End
   Begin VB.CheckBox Check4 
      Caption         =   "C2"
      Height          =   255
      Left            =   5760
      TabIndex        =   10
      Top             =   5280
      Width           =   615
   End
   Begin VB.CheckBox Check3 
      Caption         =   "C3"
      Height          =   255
      Left            =   4920
      TabIndex        =   9
      Top             =   5280
      Width           =   615
   End
   Begin VB.CheckBox Check2 
      Caption         =   "C4"
      Height          =   255
      Left            =   4080
      TabIndex        =   8
      Top             =   5280
      Width           =   615
   End
   Begin VB.CheckBox Check1 
      Caption         =   "C5"
      Height          =   255
      Left            =   3240
      TabIndex        =   7
      Top             =   5280
      Width           =   615
   End
   Begin VB.ComboBox Combo4 
      Height          =   315
      Left            =   3480
      TabIndex        =   6
      Text            =   "Combo4"
      Top             =   5760
      Width           =   1575
   End
   Begin VB.CommandButton Command4 
      Caption         =   "Single"
      Height          =   375
      Left            =   2520
      TabIndex        =   5
      Top             =   5640
      Width           =   855
   End
   Begin VB.CommandButton Command3 
      Caption         =   "Open"
      Height          =   375
      Left            =   5640
      TabIndex        =   4
      Top             =   5760
      Width           =   975
   End
   Begin VB.ComboBox Combo1 
      Height          =   315
      ItemData        =   "ATM18Logoc2.frx":0000
      Left            =   6960
      List            =   "ATM18Logoc2.frx":0002
      TabIndex        =   3
      Text            =   "COM1"
      Top             =   5760
      Width           =   975
   End
   Begin VB.CommandButton Command2 
      Caption         =   "Auto"
      Height          =   375
      Left            =   1440
      TabIndex        =   2
      Top             =   5640
      Width           =   855
   End
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   500
      Left            =   7800
      Top             =   4800
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Start"
      Height          =   375
      Left            =   240
      TabIndex        =   1
      Top             =   5640
      Width           =   975
   End
   Begin VB.PictureBox Picture1 
      BackColor       =   &H00FFFFFF&
      ForeColor       =   &H00FF0000&
      Height          =   3975
      Left            =   240
      ScaleHeight     =   261
      ScaleMode       =   0  'Benutzerdefiniert
      ScaleWidth      =   501
      TabIndex        =   0
      Top             =   240
      Width           =   7695
   End
End
Attribute VB_Name = "UniScope"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
  Dim Ch1(1000)
  Dim zoom
  Dim Pos
  Const COMmaxnumber = 9

Private Sub Plot(Pos, zoom)
  Picture1.Cls
    For n = 0 To 10
      Picture1.Line (n * 50, 0)-(n * 50, 260), &HFF00&
    Next n
    For n = 0 To 5
      Picture1.Line (0, 43 + 40 * n)-(500, 43 + 40 * n), &HFF00&
    Next n
    X1 = 0
    For n = 0 To 497 Step 3
        X2 = (Ch1(n + 5) + 256 * Ch1(n + 4))
        X2 = X2 - Pos * 80
        X2 = X2 / zoom
        If X2 < 0 Then X2 = 0
        If X2 > 500 Then Pos2 = 500
        Y1 = 240 - 32 * (Ch1(n) And 1)
        Y2 = 240 - 32 * (Ch1(n + 3) And 1)
        Picture1.Line (X1, Y1)-(X2, Y1), &H0&
        Picture1.Line (X2, Y1)-(X2, Y2), &H0&
        Y1 = 200 - 16 * (Ch1(n) And 2)
        Y2 = 200 - 16 * (Ch1(n + 3) And 2)
        Picture1.Line (X1, Y1)-(X2, Y1), &H0&
        Picture1.Line (X2, Y1)-(X2, Y2), &H0&
        Y1 = 160 - 8 * (Ch1(n) And 4)
        Y2 = 160 - 8 * (Ch1(n + 3) And 4)
        Picture1.Line (X1, Y1)-(X2, Y1), &H0&
        Picture1.Line (X2, Y1)-(X2, Y2), &H0&
        Y1 = 120 - 4 * (Ch1(n) And 8)
        Y2 = 120 - 4 * (Ch1(n + 3) And 8)
        Picture1.Line (X1, Y1)-(X2, Y1), &H0&
        Picture1.Line (X2, Y1)-(X2, Y2), &H0&
        Y1 = 80 - 2 * (Ch1(n) And 16)
        Y2 = 80 - 2 * (Ch1(n + 3) And 16)
        Picture1.Line (X1, Y1)-(X2, Y1), &H0&
        Picture1.Line (X2, Y1)-(X2, Y2), &H0&
        Y1 = 40 - 1 * (Ch1(n) And 32)
        Y2 = 40 - 1 * (Ch1(n + 3) And 32)
        Picture1.Line (X1, Y1)-(X2, Y1), &H0&
        Picture1.Line (X2, Y1)-(X2, Y2), &H0&
        X1 = X2
      Next n
End Sub



Private Sub Combo5_Change()
  b = Combo5.ListIndex
  SENDBYTE 40
  SENDBYTE b
  Text1 = b
End Sub

Private Sub Combo6_Change()
  b = Combo6.ListIndex
  SENDBYTE 50
  SENDBYTE b
  Text1 = b
End Sub

Private Sub Command1_Click()
  
  DELAY 10
  
  TIMEINIT
  CLEARBUFFER
  
  Trigger = Combo4.ListIndex
  If Trigger = 0 Then
    SENDBYTE 1
    DELAY 200
  End If
  b = 0
  b = b + Check6.Value
  b = b + 2 * Check5.Value
  b = b + 4 * Check4.Value
  b = b + 8 * Check3.Value
  b = b + 16 * Check2.Value
  b = b + 32 * Check1.Value
  If Trigger = 1 Then
    SENDBYTE 30
    SENDBYTE b
    SENDBYTE 2
    DELAY 200
  End If
  If Trigger = 2 Then
    SENDBYTE 30
    SENDBYTE b
    SENDBYTE 3
    DELAY 200
  End If
 Do
    DELAY 50
    DoEvents
 Loop Until INBUFFER() > 1
 For n = 0 To 500
   a = READBYTE()
   Ch1(n) = a
 Next n
 Plot Pos, zoom
 CLEARBUFFER
 End Sub

Private Sub Command2_Click()
  Timer1.Enabled = True
End Sub

Private Sub Command3_Click()
   Dim COMportStr As String
   COMportStr = "COM" + CStr(Combo1.ListIndex + 1) + ":115200,N,8,2"
   CLOSECOM
   i = OPENCOM(COMportStr)
   If i = 0 Then MsgBox ("COM Interface Error")
End Sub

Private Sub Command4_Click()
  Timer1.Enabled = False
End Sub

Private Sub Form_Load()
 i = OPENCOM("COM2:115200,N,8,2")
 BUFFERSIZE 2000
 If i = 0 Then MsgBox ("COM Interface Error")
 For n = 1 To COMmaxnumber
  Combo1.AddItem "COM" + CStr(n)
 Next n
 Combo1.AddItem "COM1"
 Combo1.AddItem "COM2"
 Combo1.AddItem "COM3"
 Combo1.AddItem "COM4"
 Combo1.AddItem "COM5"
 Combo1.AddItem "COM6"
 Combo1.ListIndex = 1
 Combo4.AddItem "Tigger off"
 Combo4.AddItem "Tigger +"
 Combo4.AddItem "Tigger -"
 Combo4.ListIndex = 0
 zoom = 5
 Pos = 0
End Sub

Private Sub Form_Unload(Cancel As Integer)
  Timer1.Enabled = False
  CLOSECOM
End Sub

Private Sub HScroll1_Change()
 Pos = HScroll1.Value
 Plot Pos, zoom
End Sub

Private Sub Option1_Click()
  zoom = 1
  Plot Pos, zoom
End Sub

Private Sub Option2_Click()
  zoom = 2.5
  Plot Pos, zoom
End Sub

Private Sub Option3_Click()
  zoom = 5
  Plot Pos, zoom
End Sub

Private Sub Option4_Click()
  zoom = 10
  Plot Pos, zoom
End Sub

Private Sub Option5_Click()
  zoom = 25
  Plot Pos, zoom
End Sub

Private Sub Option6_Click()
  zoom = 50
  Plot Pos, zoom
End Sub

Private Sub Timer1_Timer()
  Command1_Click
  'Plot Pos, zoom
End Sub
