VERSION 5.00
Begin VB.Form I2C 
   Appearance      =   0  '2D
   BackColor       =   &H80000016&
   Caption         =   "SI4735 Test 1"
   ClientHeight    =   8745
   ClientLeft      =   1590
   ClientTop       =   1500
   ClientWidth     =   9345
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   8.25
      Charset         =   0
      Weight          =   700
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   ForeColor       =   &H80000008&
   LinkTopic       =   "Form1"
   PaletteMode     =   1  'ZReihenfolge
   Picture         =   "SI4735Scan.frx":0000
   ScaleHeight     =   583
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   623
   Begin VB.CommandButton Command21 
      Caption         =   "Scan 500 kHz...23 MHz"
      Height          =   375
      Left            =   4200
      TabIndex        =   46
      Top             =   6120
      Width           =   2415
   End
   Begin VB.TextBox Text10 
      Height          =   405
      Left            =   2640
      TabIndex        =   45
      Text            =   "7000"
      Top             =   6120
      Width           =   735
   End
   Begin VB.CommandButton Command20 
      Caption         =   "Scan 500 kHz ab"
      Height          =   375
      Left            =   240
      TabIndex        =   44
      Top             =   6120
      Width           =   2175
   End
   Begin VB.PictureBox Picture1 
      Height          =   1935
      Left            =   120
      ScaleHeight     =   100
      ScaleMode       =   0  'Benutzerdefiniert
      ScaleWidth      =   500
      TabIndex        =   43
      Top             =   6720
      Width           =   9135
   End
   Begin VB.CommandButton Command19 
      Caption         =   "am"
      Height          =   375
      Left            =   7680
      TabIndex        =   42
      Top             =   4080
      Width           =   615
   End
   Begin VB.CommandButton Command18 
      Caption         =   "Xtal"
      Height          =   615
      Left            =   7560
      TabIndex        =   41
      Top             =   3240
      Width           =   735
   End
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   20
      Left            =   5760
      Top             =   960
   End
   Begin VB.CommandButton Command17 
      Caption         =   "Oszi-Test"
      Height          =   495
      Left            =   6120
      TabIndex        =   40
      Top             =   3960
      Width           =   1215
   End
   Begin VB.CommandButton Command16 
      Caption         =   "Power Down"
      Height          =   495
      Left            =   3600
      TabIndex        =   39
      Top             =   120
      Width           =   1935
   End
   Begin VB.Frame Frame1 
      Caption         =   "Lautstrke"
      Height          =   735
      Left            =   240
      TabIndex        =   37
      Top             =   1560
      Width           =   7815
      Begin VB.HScrollBar HScroll1 
         Height          =   255
         Left            =   1680
         Max             =   63
         TabIndex        =   38
         Top             =   240
         Value           =   63
         Width           =   5175
      End
   End
   Begin VB.CommandButton Command15 
      Caption         =   "Suchen"
      Height          =   495
      Left            =   240
      TabIndex        =   36
      Top             =   4680
      Width           =   1935
   End
   Begin VB.HScrollBar HScroll5 
      Height          =   375
      Left            =   3120
      Max             =   63
      TabIndex        =   31
      Top             =   4680
      Value           =   25
      Width           =   1215
   End
   Begin VB.HScrollBar HScroll4 
      Height          =   375
      Left            =   6000
      Max             =   63
      TabIndex        =   30
      Top             =   4680
      Value           =   5
      Width           =   1455
   End
   Begin VB.HScrollBar HScroll3 
      Height          =   375
      Left            =   5880
      Max             =   63
      TabIndex        =   27
      Top             =   2520
      Value           =   16
      Width           =   1335
   End
   Begin VB.CommandButton Command14 
      Caption         =   "-1 kHz"
      Height          =   495
      Left            =   5040
      TabIndex        =   26
      Top             =   3960
      Width           =   855
   End
   Begin VB.CommandButton Command13 
      Caption         =   "+1 kHz"
      Height          =   495
      Left            =   4080
      TabIndex        =   25
      Top             =   3960
      Width           =   855
   End
   Begin VB.CommandButton Command12 
      Caption         =   "-5 kHz"
      Height          =   495
      Left            =   3120
      TabIndex        =   24
      Top             =   3960
      Width           =   855
   End
   Begin VB.CommandButton Command11 
      Caption         =   "+5 kHz"
      Height          =   495
      Left            =   2160
      TabIndex        =   23
      Top             =   3960
      Width           =   855
   End
   Begin VB.CommandButton Command10 
      Caption         =   "-9 kHz"
      Height          =   495
      Left            =   1200
      TabIndex        =   22
      Top             =   3960
      Width           =   855
   End
   Begin VB.CommandButton Command9 
      Caption         =   "+9 kHz"
      Height          =   495
      Left            =   240
      TabIndex        =   21
      Top             =   3960
      Width           =   855
   End
   Begin VB.HScrollBar HScroll2 
      Height          =   375
      Left            =   2880
      Max             =   4
      TabIndex        =   18
      Top             =   2520
      Value           =   3
      Width           =   1335
   End
   Begin VB.CommandButton Command8 
      Caption         =   "RSQ Status"
      Height          =   495
      Left            =   2880
      TabIndex        =   17
      Top             =   5400
      Width           =   1575
   End
   Begin VB.TextBox Text6 
      Height          =   495
      Left            =   6120
      TabIndex        =   16
      Text            =   "Text6"
      Top             =   3240
      Width           =   1335
   End
   Begin VB.TextBox Text5 
      Height          =   495
      Left            =   4680
      TabIndex        =   15
      Text            =   "Text5"
      Top             =   3240
      Width           =   1215
   End
   Begin VB.TextBox Text2 
      Height          =   495
      Left            =   6240
      TabIndex        =   14
      Text            =   "Text2"
      Top             =   5400
      Width           =   1335
   End
   Begin VB.TextBox Text1 
      Height          =   495
      Left            =   4800
      TabIndex        =   13
      Text            =   "Text1"
      Top             =   5400
      Width           =   1215
   End
   Begin VB.CommandButton Command7 
      Caption         =   "AM Tune Status"
      Height          =   495
      Left            =   2760
      TabIndex        =   12
      Top             =   3240
      Width           =   1575
   End
   Begin VB.OptionButton Option4 
      Appearance      =   0  '2D
      BackColor       =   &H80000016&
      Caption         =   "COM4"
      Height          =   255
      Left            =   7680
      TabIndex        =   11
      Top             =   600
      Width           =   1095
   End
   Begin VB.OptionButton Option3 
      Appearance      =   0  '2D
      BackColor       =   &H80000016&
      Caption         =   "COM3"
      Height          =   255
      Left            =   6480
      TabIndex        =   10
      Top             =   600
      Width           =   1095
   End
   Begin VB.CommandButton Command6 
      Caption         =   "Suchen  max. 2 s"
      Height          =   495
      Left            =   240
      TabIndex        =   9
      Top             =   5400
      Width           =   1935
   End
   Begin VB.CommandButton Command5 
      Caption         =   " kHz"
      Height          =   495
      Left            =   1560
      TabIndex        =   8
      Top             =   3240
      Width           =   855
   End
   Begin VB.CommandButton Command4 
      Caption         =   "Suchen max 1 s"
      Height          =   495
      Left            =   3480
      TabIndex        =   7
      Top             =   840
      Width           =   2055
   End
   Begin VB.CommandButton Command3 
      Caption         =   "AM"
      Height          =   495
      Left            =   240
      TabIndex        =   6
      Top             =   2520
      Width           =   1935
   End
   Begin VB.CommandButton Command2 
      Caption         =   "/100 MHz"
      Height          =   495
      Left            =   1800
      TabIndex        =   5
      Top             =   840
      Width           =   1095
   End
   Begin VB.CommandButton Command1 
      Caption         =   "FM"
      Height          =   495
      Left            =   240
      TabIndex        =   4
      Top             =   120
      Width           =   1935
   End
   Begin VB.TextBox Text4 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   240
      TabIndex        =   3
      Text            =   "549"
      Top             =   3240
      Width           =   1215
   End
   Begin VB.TextBox Text3 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   240
      TabIndex        =   2
      Text            =   "8800"
      Top             =   840
      Width           =   1215
   End
   Begin VB.OptionButton Option1 
      Appearance      =   0  '2D
      BackColor       =   &H80000016&
      Caption         =   "COM1"
      ForeColor       =   &H80000008&
      Height          =   255
      Left            =   6480
      TabIndex        =   0
      Top             =   240
      Width           =   1095
   End
   Begin VB.OptionButton Option2 
      Appearance      =   0  '2D
      BackColor       =   &H80000016&
      Caption         =   "COM2"
      Height          =   255
      Left            =   7680
      TabIndex        =   1
      Top             =   240
      Value           =   -1  'True
      Width           =   1095
   End
   Begin VB.Label Label8 
      Caption         =   "25 dBV"
      Height          =   255
      Left            =   4440
      TabIndex        =   35
      Top             =   4800
      Width           =   975
   End
   Begin VB.Label Label7 
      Caption         =   "RSSI"
      Height          =   255
      Left            =   2400
      TabIndex        =   34
      Top             =   4800
      Width           =   615
   End
   Begin VB.Label Label6 
      Caption         =   "5 dB"
      Height          =   255
      Left            =   7560
      TabIndex        =   33
      Top             =   4800
      Width           =   615
   End
   Begin VB.Label Label5 
      Caption         =   "SNR"
      Height          =   255
      Left            =   5400
      TabIndex        =   32
      Top             =   4800
      Width           =   495
   End
   Begin VB.Label Label4 
      BackColor       =   &H80000016&
      Caption         =   "16 db/db"
      Height          =   255
      Left            =   7320
      TabIndex        =   29
      Top             =   2640
      Width           =   1095
   End
   Begin VB.Label Label3 
      BackColor       =   &H80000016&
      Caption         =   "Mute"
      Height          =   255
      Left            =   5280
      TabIndex        =   28
      Top             =   2640
      Width           =   735
   End
   Begin VB.Label Label2 
      BackColor       =   &H80000016&
      Caption         =   "b"
      Height          =   255
      Left            =   2640
      TabIndex        =   20
      Top             =   2640
      Width           =   255
   End
   Begin VB.Label Label1 
      BackColor       =   &H80000016&
      Caption         =   "2 kHz"
      Height          =   255
      Left            =   4440
      TabIndex        =   19
      Top             =   2640
      Width           =   735
   End
End
Attribute VB_Name = "I2C"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim Status, Freq, RSSI, SNR, VCAP
Sub i2cStart()
    DTR 1  'SDA 0
    DELAY 0.2
    RTS 1  'SCL 0
    DELAY 0.2
End Sub

Sub i2cStop()
    DTR 1  'SDA 0
    DELAY 0.2
    RTS 0  'SCL 1
    DELAY 0.2
    DTR 0  'SDA 1
    DELAY 0.2
End Sub

Function i2cOut(Wert) As Integer
    i2cOut = 1       'kein Fehler
    Bit = 128
    For n = 1 To 8
      If (Wert And Bit) = 0 Then DTR 1 Else DTR 0
      DELAY 0.2
      RTS 0          'Clock
      DELAY 0.2
      RTS 1
      DELAY 0.2
      Bit = Bit / 2
    Next n
    DTR 0            'SDA 1
    DELAY 0.2
    RTS 0            '9. Clockimpuls fr Ack
    DELAY 0.2
    If CTS = 0 Then i2cOut = 0  'Fehler
    DELAY 0.2
    RTS 1
    DELAY 2.2
End Function

Sub i2cAck()
    DTR 1
    DELAY 0.2
    RTS 0     'Ack
    DELAY 0.2
    RTS 1
    DELAY 0.2
    DTR 0
    DELAY 0.2
End Sub

Sub i2cNak()
    DTR 0
    DELAY 0.2
    RTS 0     'Nak
    DELAY 0.2
    RTS 1
    DELAY 0.2
End Sub

Function i2cIn()
    Bit = 128
    Wert = 0
    For n = 1 To 8
        RTS 0   'SCL
        DELAY 0.2
        If CTS = 0 Then Wert = Wert + Bit
        DELAY 0.2
        RTS 1
        DELAY 0.2
       Bit = Bit / 2
    Next n
    i2cIn = Wert
End Function
Private Sub Xtal()
    Prop &H202, 125   '4 MHz / 125 = 32 kHz
    DELAY 100
    Prop &H201, 32000
    DELAY 100
End Sub

Private Sub Prop(Adr, Data)
    i2cStart
    r = i2cOut(34)
    Text7 = r
    i2cOut &H12
    i2cOut &H0
    i2cOut Adr \ 256
    i2cOut Adr And 255
    i2cOut Data \ 256
    i2cOut Data And 255
    i2cStop
End Sub
Sub PowerDown()
   i2cStart
   i2cOut 34
   i2cOut &H11
   i2cStop
End Sub
Sub Init_AM()
 REALTIME
 i2cStart
 i2cOut 34 'Bus-Adresse
 i2cOut (&H1)      '01
 i2cOut (&H1)      '01 AM, ext. Osz
 i2cOut (&H5)      '05 Rout/Lout
 i2cStop
 NORMALTIME
 DELAY 250
End Sub
Sub Init_FM()
 REALTIME
 i2cStart
 i2cOut 34 'Bus-Adresse
 i2cOut (&H1)      '01
 i2cOut (&H0)      '00 FM, ext. Osz
 i2cOut (&H5)      '05 Rout/Lout
 i2cStop
 NORMALTIME
 DELAY 250
End Sub



Sub FM_Seek_Freq()
   i2cStart
   i2cOut 34
   i2cOut &H21
   i2cOut &H8
   i2cStop
End Sub
Sub AM_Seek_Freq()
   i2cStart
   i2cOut 34
   i2cOut &H41
   i2cOut &H8
   i2cStop
End Sub
Sub FM_Tune_Freq(f)
  i2cStart
  i2cOut 34
  i2cOut &H20
  i2cOut &H0
  i2cOut f \ 256
  i2cOut f And 255
  i2cOut& H0
  i2cStop
End Sub

Sub AM_Tune_Freq(f)
  i2cStart
  i2cOut 34
  i2cOut &H40
  i2cOut &H0
  i2cOut f \ 256
  i2cOut f And 255
  i2cOut &H0
  i2cStop
End Sub

Sub Get_Int_Status()
  i2cStart
  i2cOut 34
  i2cOut &H14
  i2cStop
  i2cStart
  i2cOut 35
  Status = i2cIn()
  i2cNak
  i2cStop
End Sub


Sub FM_Tune_Status()
  i2cStart
  i2cOut 34
  i2cOut &H22
  i2cOut &H3
  i2cStop
  i2cStart
  i2cOut 35
  Status = i2cIn(): i2cAck
  R1 = i2cIn(): i2cAck
  R2 = i2cIn(): i2cAck
  R3 = i2cIn(): i2cAck
  Freq = 256 * R2 + R3
  R4 = i2cIn(): i2cAck
  RSSI = R4
  R5 = i2cIn(): i2cAck
  SNR = R5
  R6 = i2cIn(): i2cAck
  R7 = i2cIn(): i2cNak
  VCAP = R7
  i2cStop
End Sub

Sub AM_Tune_Status()
  i2cStart
  i2cOut 34
  i2cOut &H42
  i2cOut &H3
  i2cStop
  i2cStart
  i2cOut 35
  Status = i2cIn(): i2cAck
  R1 = i2cIn(): i2cAck
  R2 = i2cIn(): i2cAck
  R3 = i2cIn(): i2cAck
  Freq = 256 * R2 + R3
  R4 = i2cIn(): i2cAck
  RSSI = R4
  R5 = i2cIn(): i2cAck
  SNR = R5
  R6 = i2cIn(): i2cAck
  R7 = i2cIn(): i2cNak
  VCAP = 256 * R6 + R7
  i2cStop
End Sub
Sub AM_RSQ_Status()
  i2cStart
  i2cOut 34
  i2cOut &H43
  i2cOut &H0
  i2cStop
  i2cStart
  i2cOut 35
  Status = i2cIn(): i2cAck
  R1 = i2cIn(): i2cAck
  R2 = i2cIn(): i2cAck
  R3 = i2cIn(): i2cAck
  R4 = i2cIn(): i2cAck
  RSSI = R4
  R5 = i2cIn(): i2cNak
  SNR = R5
  i2cStop
End Sub

Private Sub Command1_Click()
 TIMEINIT
 TXD 1
 DELAY 200
 i2cStop
 DELAY 10
 TXD 0
 DELAY 200
  i2cStart
  r = i2cOut(34) 'Bus-Adresse PCF8574
  i2cOut (&H1)      '01
  i2cOut (&H0)      '0 UKW, ext. Osz.
  i2cOut (&H5)      '01
  i2cStop
  DELAY 250
  Xtal
  DELAY 50
  HScroll1.Value = 63
  FM_Tune_Freq 8800
  Text3.Text = "8800"
End Sub

Private Sub Command14_Click()
  f = Val(Text4)
  f = f - 1
  Text4 = Str(f)
  AM_Tune_Freq f
End Sub

Private Sub Command13_Click()
  f = Val(Text4)
  f = f + 1
  Text4 = Str(f)
  AM_Tune_Freq f
End Sub

Private Sub Command12_Click()
  f = Val(Text4)
  f = f - 5
  Text4 = Str(f)
  AM_Tune_Freq f
End Sub

Private Sub Command11_Click()
  f = Val(Text4)
  f = f + 5
  Text4 = Str(f)
  AM_Tune_Freq f
End Sub

Private Sub Command10_Click()
  f = Val(Text4)
  f = f - 9
  Text4 = Str(f)
  AM_Tune_Freq f
End Sub

Private Sub Command15_Click()
  f = Val(Text4)
  If f < 2300 Then Prop &H3402, 9    '9 kHz Weite beim Suchen
  If f > 2300 Then Prop &H3402, 5    '5 kHz Weite beim Suchen
  If f < 500 Then Prop &H3402, 1    '1 kHz Weite beim Suchen
  AM_Seek_Freq
End Sub

Private Sub Command16_Click()
  PowerDown
End Sub

Private Sub Command17_Click()
 Timer1.Enabled = True
End Sub

Private Sub Command18_Click()
 Xtal
End Sub

Private Sub Command19_Click()
Init_AM
End Sub

Private Sub Command2_Click()
  f = Val(Text3)
  FM_Tune_Freq (f)
End Sub

Private Sub Command20_Click()
Picture1.Cls
For x = 1 To 5
 Picture1.Line (x * 100, 0)-(x * 100, 100), &HFF00&
Next x
For x = 1 To 4
 Picture1.Line (0, 20 * x)-(600, 20 * x), &HFF00&
Next x
Fstart = Val(Text10.Text)
For x = 0 To 500 Step 5
  f = Fstart + x
  Text4 = f
  AM_Tune_Freq f
  DELAY 50
  AM_Tune_Status
  Text1 = RSSI
  Text2 = SNR
  Picture1.Line (x, 100)-(x, 100 - RSSI)
  Picture1.Line (x, o)-(x, SNR)
 DoEvents
Next x

End Sub

Private Sub Command21_Click()
Picture1.Cls
For x = 1 To 5
 Picture1.Line (x * 100, 0)-(x * 100, 100), &HFF00&
Next x
For x = 1 To 4
 Picture1.Line (0, 20 * x)-(600, 20 * x), &HFF00&
Next x
Fstart = Val(Text10.Text)
For x = 500 To 23000 Step 5
  f = x
  Text4 = f
  AM_Tune_Freq f
  DELAY 50
  AM_Tune_Status
  Text1 = RSSI
  Text2 = SNR
  Picture1.Line (x / 50, 100)-(x / 50, 100 - RSSI)
  Picture1.Line (x / 50, o)-(x / 50, SNR)
 DoEvents
Next x

End Sub

Private Sub Command3_Click()
 'TIMEINIT
 'TXD 1
 'DELAY 50
 'i2cStop
 'DELAY 50
 'TXD 0
 PowerDown
 DELAY 200
 Get_Int_Status
 Init_AM
 Get_Int_Status
 Text8 = Status
 Xtal  'kein Vorteiler wenn 32 kHz
 Get_Int_Status
 Text8 = Status
 DELAY 50
 HScroll1.Value = 63
 AM_Tune_Freq 549
 Text4.Text = "549"
End Sub

Private Sub Command4_Click() 'FM-SEEK
  FM_Seek_Freq
  DELAY 1000
  FM_Tune_Status
  Text3.Text = Freq
End Sub

Private Sub Command5_Click()
  f = Val(Text4)
  AM_Tune_Freq f
  DELAY 500
  AM_Tune_Status
  Text4.Text = Freq
  Text1.Text = Str(RSSI) + " dBuV"
  Text2.Text = Str(SNR) + " dB SNR"
   VCAP = VCAP * 0.095 + 7
  Text5.Text = Str(VCAP) + " pF"
  If Freq > 0 Then L = 1000000000000# / (4 * 3.1415 * 3.1415 * VCAP * Freq * Freq)
  L = Int(L * 100) / 100
  Text6.Text = Str(L) + " H"
End Sub

Private Sub Command6_Click()
  f = Val(Text4)
  If f < 2300 Then Prop &H3402, 9    '9 kHz Weite beim Suchen
  If f > 2300 Then Prop &H3402, 5    '5 kHz Weite beim Suchen
  If f < 500 Then Prop &H3402, 1    '1 kHz Weite beim Suchen
  AM_Seek_Freq
  DELAY 2000
  AM_Tune_Status
  Text4.Text = Freq
  Text1.Text = Str(RSSI) + " dBuV"
  Text2.Text = Str(SNR) + " dB SNR"
   VCAP = VCAP * 0.095 + 7
  Text5.Text = Str(VCAP) + " pF"
  If Freq > 0 Then L = 1000000000000# / (4 * 3.1415 * 3.1415 * VCAP * Freq * Freq)
  L = Int(L * 100) / 100
  Text6.Text = Str(L) + " H"

End Sub

Private Sub Command7_Click()
  AM_Tune_Status
  Text4.Text = Freq
  Text1.Text = Str(RSSI) + " dBuV"
  Text2.Text = Str(SNR) + " dB SNR"
  VCAP = VCAP * 0.095 + 7
  Text5.Text = Str(VCAP) + " pF"
  If Freq > 0 Then L = 1000000000000# / (4 * 3.1415 * 3.1415 * VCAP * Freq * Freq)
  L = Int(L * 100) / 100
  Text6.Text = Str(L) + " H"
  
End Sub

Private Sub Command8_Click()
  AM_RSQ_Status
  Text1.Text = Str(RSSI) + " dBuV"
  Text2.Text = Str(SNR) + " dB SNR"
End Sub

Private Sub Command9_Click()
  f = Val(Text4)
  f = f + 9
  Text4 = Str(f)
  AM_Tune_Freq f
End Sub

Private Sub Form_Load()
 i = OPENCOM("COM2:9600,N,8,1")
 If i = 0 Then
    i = OPENCOM("COM1:9600,N,8,1")
    Option1.Value = True
 End If
 If i = 0 Then MsgBox ("COM Error")
 TIMEINIT
 DELAY 100
' TXD 1
' DELAY 100
 i2cStop
' DELAY 10
' TXD 0
End Sub

Private Sub Form_Unload(Cancel As Integer)
 TXD 0
 CLOSECOM
End Sub

Private Sub HScroll1_Change()
  L = HScroll1.Value
    i2cStart
    i2cOut 34
    i2cOut &H12
    i2cOut &H0
    i2cOut &H40
    i2cOut &H0
    i2cOut 0
    i2cOut L
    i2cStop
End Sub

Private Sub HScroll2_Change()
 Prop &H3102, HScroll2.Value
 If HScroll2.Value = 4 Then Label1.Caption = "1 kHz"
 If HScroll2.Value = 3 Then Label1.Caption = "2 kHz"
 If HScroll2.Value = 2 Then Label1.Caption = "3 kHz"
 If HScroll2.Value = 1 Then Label1.Caption = "4 kHz"
 If HScroll2.Value = 0 Then Label1.Caption = "6 kHz"
End Sub

Private Sub HScroll3_Change()
 Prop &H3303, HScroll3.Value
 Label4.Caption = Str(HScroll3.Value) + " dB/dB"

End Sub

Private Sub HScroll4_Change()

 Prop &H3403, HScroll4.Value
 Label6.Caption = Str(HScroll4.Value) + " dB"
End Sub

Private Sub HScroll5_Change()
 Prop &H3404, HScroll5.Value
 Label8.Caption = Str(HScroll5.Value) + " dBV"

End Sub

Private Sub Option1_Click()
 CLOSECOM
 i = OPENCOM("COM1:9600,N,8,1")
 If i = 0 Then MsgBox ("COM1 Error")
End Sub

Private Sub Option2_Click()
 CLOSECOM
 i = OPENCOM("COM2:9600,N,8,1")
 If i = 0 Then MsgBox ("COM2 Error")
End Sub

Private Sub Option3_Click()
 CLOSECOM
 i = OPENCOM("COM3:9600,N,8,1")
 If i = 0 Then MsgBox ("COM3 Error")
End Sub

Private Sub Option4_Click()
 CLOSECOM
 i = OPENCOM("COM4:9600,N,8,1")
 If i = 0 Then MsgBox ("COM4 Error")
End Sub



Private Sub Timer1_Timer()
   i2cStart
   i2cOut 34
   i2cOut &H11
   i2cStop

End Sub
