unit CompUSB;
//gendert 29.7.: Letzter Parameter bei CreateFile: 0
//Fehlerabfrage bei CreateFile und DeviceIOControl ausgewertet
interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    CheckBox7: TCheckBox;
    CheckBox8: TCheckBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Timer1: TTimer;
    Label9: TLabel;
    CheckBox9: TCheckBox;
    CheckBox10: TCheckBox;
    CheckBox11: TCheckBox;
    CheckBox12: TCheckBox;
    CheckBox13: TCheckBox;
    CheckBox14: TCheckBox;
    CheckBox15: TCheckBox;
    CheckBox16: TCheckBox;
    Label10: TLabel;
    Edit1: TEdit;
    Label11: TLabel;
    Edit2: TEdit;
    Label12: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  end;

type _lIn  = record
    bFunction : Byte;
    bValue1 : Byte;
    bValue2 : Byte;
    bValue3 : Byte;
end;

type _lOut  = record
    bAck : Byte;
    bValue1 : Byte;
    bValue2 : Byte;
    bValue3 : Byte;
    bValue4 : Byte;
    bValue5 : Byte;
    bValue6 : Byte;
    bValue7 : Byte;
end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure WrRAM(Adresse, Wert: Byte);
var lIn: _lIn;
    lOut: _lOut;
    DeviceHandle: THandle;
    nBytes: DWord;
begin
  lIn.bFunction := 23;
  lIn.bValue1 := Adresse;
  lIn.bValue2 := Wert;
  DeviceHandle := CreateFile ('\\.\CompuLABusb_0',Generic_write,File_Share_write,nil,open_existing,0,0);
  if (DeviceHandle <> INVALID_HANDLE_VALUE) then DeviceIoControl(DeviceHandle,$04,@lIn,sizeof(lIn),@lOut,sizeof (lOut),nBytes,nil);
  CloseHandle (DeviceHandle);
end;


procedure TForm1.FormCreate(Sender: TObject);
begin
  Timer1.Interval := 100;
  Timer1.Enabled := true;
  WrRAM ($34,$80); //AD-Startkanal festlegen;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var DeviceHandle: THandle;
    nBytes: DWord;
    bresult: Boolean;
    Dout, Din: Byte;
    lIn: _lIn;
    lOut: _lOut;
    AnA, AnB: Real;
begin
  Dout := 0;
  if  CheckBox1.Checked Then Dout := Dout +1;
  if  CheckBox2.Checked Then Dout := Dout +2;
  if  CheckBox3.Checked Then Dout := Dout +4;
  if  CheckBox4.Checked Then Dout := Dout +8;
  if  CheckBox5.Checked Then Dout := Dout +16;
  if  CheckBox6.Checked Then Dout := Dout +32;
  if  CheckBox7.Checked Then Dout := Dout +64;
  if  CheckBox8.Checked Then Dout := Dout +128;

  lIn.bFunction := 6;
  lIn.bValue1 := Dout;
  Din := 0;
  AnA := 0;
  AnB := 0;
  bresult := false;
  DeviceHandle := CreateFile ('\\.\CompuLABusb_0',Generic_write,File_Share_write,nil,open_existing,0,0);
  if (DeviceHandle <> INVALID_HANDLE_VALUE) then begin
     bResult := DeviceIoControl(DeviceHandle,$08,@lIn,sizeof(lIn),@lOut,sizeof (lOut),nBytes,nil);
     CloseHandle (DeviceHandle);
  end;
  if bResult then begin
    Din := lOut.bValue1;
    AnA := (4*lOut.bValue2+ (lOut.bValue4 and 15))/1023*5;
    AnB := (4*lOut.bValue3+ (lOut.bValue4 div 16))/1023*5;
  end;

  CheckBox9.Checked := ((Din And 1) >0);
  CheckBox10.Checked := ((Din And 2) >0);
  CheckBox11.Checked := ((Din And 4) >0);
  CheckBox12.Checked := ((Din And 8) >0);
  CheckBox13.Checked := ((Din And 16) >0);
  CheckBox14.Checked := ((Din And 32) >0);
  CheckBox15.Checked := ((Din And 64) >0);
  CheckBox16.Checked := ((Din And 128) >0);
  Edit1.Text := FloatToStrF(AnA,ffFixed,3,2) + ' V';
  Edit2.Text := FloatToStrF(AnB,ffFixed,3,2) + ' V';
end;

end.
