;EZad.asm
#include 8051.h
OEA  .equ   7F9Ch
OEB  .equ   7F9Dh
OEC  .equ   7F9Eh
PINSA .equ  7F99h
PINSB .equ  7F9Ah
PINSC .equ  7F9Bh
OUTA .equ   7F96h
OUTB .equ   7F97h
OUTC .equ   7F98h
DPS  .equ   86h

     lcall initMAX186
     lcall initPortC
Loop lcall InOut
     sjmp Loop

initPortC
     mov DPTR,#OUTC
     mov A,#255
     movx @DPTR,A
     ret

initMAX186
     mov DPTR,#OEB
     mov a,#7    ;PortB0...2 Outputs
     movx @DPTR,a
     mov DPTR,#OUTB
     mov a,#2    ;/CS = 1
     movx @DPTR,a
     ret

Delay		;delay [a] times 
     mov R1,#255
S0   djnz R1,S0
     dec a
     jnz Delay
     ret

RdAD		;Control byte in A
     mov R3,a	;save Control Byte
     mov DPTR,#OUTB
     mov a,0	;/CS = 0
     movx @DPTR,a
;*** Transfer control byte ***
     mov A,#0	
     mov R2,#8 
S1   Xch a,R3     	;Control-Byte
     jnb ACC.7,S2	;Bit7 = 1?
     mov R3,#4		;Din = 1
S2   xch a,R3
     movx @DPTR,a
     inc a		;SCLK = 1
     movx @DPTR,a
     dec a
     movx @DPTR,a  	;SCLK = 0
     mov a,#0      	;Din =0
     xch a,R3
     rl  a  		;next Bit
     xch a,R3
     djnz R2,S1
;*** Wait for conversion complete ***
     mov R2,#30
S3   djnz R2,S3 	;delay > 10 s
;*** Read highbyte to R3 ***
     mov R3,#0 		;Highbyte > R3
     mov R2,#8
S4   xch a,R3
     rl  a
     xch a,R3
     mov DPTR,#OUTB
     mov a,#1		;SCLK = 1
     movx @DPTR,a 
     mov a,#0		;SCLK = 0
     movx @DPTR,a 
     mov DPTR,#PINSB 
     movx a,@DPTR
     jnb ACC.4,S5
     inc R3
S5   djnz R2,S4  
;*** Read lowbyte to R4 ***
     mov R4,#0 		;Lowbyte > R4
     mov R2,#4
S6   xch a,R4
     rl  a
     xch a,R4
     mov DPTR,#OUTB
     mov a,#1		;SCLK = 1
     movx @DPTR,a 
     mov a,#0		;SCLK = 0
     movx @DPTR,a 
     mov DPTR,#PINSB 
     movx a,@DPTR
     jnb ACC.4,S7
     inc R4
S7   djnz R2,S6

     mov DPTR,#OUTB
     mov a,#2		;/CS = 1
     movx @DPTR,a 
     ret


InOut
     mov a,#142	;Ch0
     lcall RdAD
     mov a,R3	;Highbyte
     mov DPTR,#0200h  
     movx @DPTR,A
     mov a,R4	;Lowbyte
     inc DPTR  
     movx @DPTR,A

     mov a,#206	;Ch1
     lcall RdAD
     mov a,R3	;Highbyte
     mov DPTR,#0202h  
     movx @DPTR,A
     mov a,R4	;Lowbyte
     inc DPTR  
     movx @DPTR,A

     mov a,#158	;Ch2
     lcall RdAD
     mov a,R3	;Highbyte
     mov DPTR,#0204h  
     movx @DPTR,A
     mov a,R4	;Lowbyte
     inc DPTR  
     movx @DPTR,A

     mov a,#222	;Ch3
     lcall RdAD
     mov a,R3	;Highbyte
     mov DPTR,#0206h  
     movx @DPTR,A
     mov a,R4	;Lowbyte
     inc DPTR  
     movx @DPTR,A

     mov a,#174	;Ch4   
     lcall RdAD
     mov a,R3	;Highbyte
     jnz min1
     inc a
min1     mov DPTR,#0208h   ;Notlsung wg. Bug im EZusb?
     movx @DPTR,A
     mov a,R4	;Lowbyte
     inc DPTR  
     movx @DPTR,A

     mov a,#238	;Ch5
     lcall RdAD
     mov a,R3	;Highbyte
     mov DPTR,#020Ah  
     movx @DPTR,A
     mov a,R4	;Lowbyte
     inc DPTR  
     movx @DPTR,A

     mov a,#190	;Ch6
     lcall RdAD
     mov a,R3	;Highbyte
     mov DPTR,#020Ch  
     movx @DPTR,A
     mov a,R4	;Lowbyte
     inc DPTR  
     movx @DPTR,A

     mov a,#254	;Ch7
     lcall RdAD
     mov a,R3	;Highbyte
     mov DPTR,#020Eh  
     movx @DPTR,A
     mov a,R4	;Lowbyte
     inc DPTR  
     movx @DPTR,A

     mov DPTR,#0210h
     movx a,@DPTR
     mov DPTR,#OUTC
     movx @DPTR,a

     mov a,#1
     lcall Delay
     ret

.End
