//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#include <vcl\IniFiles.hpp>
#include <stdio.h>
#include <string.h>
#pragma hdrstop

#include "mainform.h"
//---------------------------------------------------------------------------
#pragma link "Grids"
#pragma link "HW_32"
#pragma resource "*.dfm"

static char *PointPhys = NULL;
static int Flag_Intr,Flag_Tim,Sum_Ticks,CurrTicker,OldTicker,
       PhysAddr, CurrAddr,N_IRQ;
static Word  PortWSel,PortRSel,NomWSel,NomRSel;
UCHAR ValWSel;


TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
void ShowButtons()
{
   Form1->C_Hard->Checked = Form1->HwCtrl->HardAccess;

   Form1->UpIRQ->Enabled = !(Form1->HwCtrl->IsIRQSet);
   if (Form1->HwCtrl->ActiveHW) Form1->B_Open->Caption ="Close Driver";
                           else Form1->B_Open->Caption ="Open Driver";
   Form1->B_Write->Enabled = Form1->HwCtrl->ActiveHW;
   Form1->B_Read->Enabled = Form1->HwCtrl->ActiveHW;
   Form1->B_WriteAll->Enabled = Form1->HwCtrl->ActiveHW;
   Form1->B_ReadAll->Enabled = Form1->HwCtrl->ActiveHW;
   Form1->B_ReadMemory->Enabled = Form1->HwCtrl->ActiveHW & (PointPhys != NULL);
   Form1->B_FillMemory->Enabled = Form1->HwCtrl->ActiveHW &
                                 (PointPhys!=NULL);
   Form1->B_SetIRQ->Enabled = Form1->HwCtrl->ActiveHW;
   if (Form1->HwCtrl->IsIRQSet) {Form1->B_SetIRQ->Caption = "Destroy IRQ";}
                           else Form1->B_SetIRQ->Caption = "Set IRQ";
   Form1->B_Pulse->Enabled = (Form1->HwCtrl->ActiveHW) & (Form1->HwCtrl->IsIRQSet) &
                                    (Form1->HwCtrl->Masked);
   Form1->B_Mask->Enabled = Form1->HwCtrl->IsIRQSet;
   if (Form1->HwCtrl->Masked) Form1->B_Mask->Caption="Unmask IRQ";
                         else Form1->B_Mask->Caption="Mask IRQ";
  
};
//---------------------------------------------------------------------------
void __fastcall TForm1::UpIRQClick(TObject *Sender, TUDBtnType Button)
{
 N_IRQ = UpIRQ->Position;
 L_IRQ->Caption = IntToStr(N_IRQ);
 HwCtrl->IRQNumber = N_IRQ;
 ShowButtons();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::C_HardClick(TObject *Sender)
{
 HwCtrl->HardAccess = C_Hard->Checked;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::B_OpenClick(TObject *Sender)
{
  if (HwCtrl->ActiveHW) { HwCtrl->CloseDriver(); PointPhys = NULL;}
  else {
         HwCtrl->OpenDriver();
         if(!HwCtrl->ActiveHW) {
           MessageBeep(0);
           Application->MessageBox("Driver < VICHWxx > not found",
                      " Warning! ",IDOK);
         };
       };
  B_SetMemory->Enabled = HwCtrl->ActiveHW;
  ShowButtons();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::BitBtn3Click(TObject *Sender)
{
 int i;
 TIniFile* MyIniFile = new TIniFile("HW_test");
 MyIniFile->WriteInteger("misc","ADDR",PhysAddr);
 MyIniFile->WriteInteger("misc","IRQ",N_IRQ);
 for (i=1; i<=16; i++) {
    MyIniFile->WriteString("PortW","Port"+IntToStr(i),GWrite->Cells[1][i]);
    MyIniFile->WriteString("Values","Val"+IntToStr(i),GWrite->Cells[2][i]);
    MyIniFile->WriteString("PortR","Port"+IntToStr(i),GRead->Cells[1][i]);
 }
 delete MyIniFile;
 Close();        
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Timer1Timer(TObject *Sender)
{
    L_Gen->Caption = IntToStr(HwCtrl->IRQCounter);
    L_Timers->Caption = IntToStr(Flag_Tim / 1000);
    L_Flag->Caption = IntToStr(Flag_Intr);
    if (HwCtrl->ActiveHW & HwCtrl->IsIRQSet & (!HwCtrl->Masked))
    {
      CurrTicker = GetTickCount();
      Flag_Tim = Sum_Ticks+CurrTicker-OldTicker;
    } else  OldTicker = GetTickCount();

}
//---------------------------------------------------------------------------
void __fastcall TForm1::B_SetIRQClick(TObject *Sender)
{
  Flag_Intr = 0;
  HwCtrl->IRQNumber = UpIRQ->Position;
  Flag_Tim = 0;
  if (!(HwCtrl->IsIRQSet)) HwCtrl->SetIRQ();
  else HwCtrl->DestroyIRQ();
  Sum_Ticks = 0;
  ShowButtons();

}
//---------------------------------------------------------------------------
void __fastcall TForm1::B_MaskClick(TObject *Sender)
{
  if (!HwCtrl->Masked) {
     HwCtrl->MaskInterrupt();
     Sum_Ticks = Flag_Tim;
  }
  else HwCtrl->UnmaskInterrupt();
  ShowButtons();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::B_PulseClick(TObject *Sender)
{
  HwCtrl->SimulateHwInt();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::HwCtrlHwInterrupt(TObject *Sender)
{
  Flag_Intr++;
}
ULONG CharToNumber(char ch)
{
  int n,i;
  char hexh[17] = "0123456789ABCDEF";
  n = 0;
  for (i=0;i<=15;i++){ if (UpperCase(ch)==hexh[i]) n=i; }
  return n;
}

int HexToInt(AnsiString s)
{

  int i,r,k;
  char    ch;

  k=1; r=0;
  for (i=s.Length();i>0; i--){
    ch=s[i];
    r=r+CharToNumber(ch)*k; if (i>1) k*=16;
  }
  return r;
}


//---------------------------------------------------------------------------
void __fastcall TForm1::B_SetMemoryClick(TObject *Sender)
{
  ULONG i,n;
  PhysAddr=0; n=0x10000000L;
  for (i=1; i<=8; i++){
    PhysAddr=PhysAddr+CharToNumber(E_Addr->Text[i])*n; n=n>>4;
  };
  E_Addr->Text = IntToHex(PhysAddr,8);
  PointPhys = (PCHAR) HwCtrl->MapPhysToLinear(PhysAddr,256);
  B_SetMemory->Enabled = false;
  ShowButtons();
}

//---------------------------------------------------------------------------
void __fastcall TForm1::E_AddrChange(TObject *Sender)
{
  B_SetMemory->Enabled = true;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::B_ReadMemoryClick(TObject *Sender)
{
int i,j;
AnsiString s;
char b;
PUCHAR LocP;

  if (PointPhys) {
    CurrAddr=PhysAddr;
    for (i=1; i<=16; i++) {
      MemoHex->Cells[0][i]=IntToHex(CurrAddr,8); s="";
      LocP = (PUCHAR) PointPhys;
      for (j=1; j<=16; j++) s = s+IntToHex(*LocP++,2);
      MemoHex->Cells[1][i]=s; s ="";
      for (j=1; j<=16; j++){
        b=*PointPhys++;
        if (b<0x20) b='.';
        s=s+b;
      }
      MemoHex->Cells[2][i]=s;
      CurrAddr+=16;
    }

  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormActivate(TObject *Sender)
{
 int i;



 if ((int)GetVersion()<0) Label3->Caption = "Detected: Windows 95";
 else              Label3->Caption = "Detected: Windows NT";
 ShowButtons();

 TIniFile* MyIniFile = new TIniFile("HW_test");
 
 PhysAddr=MyIniFile->ReadInteger("misc","ADDR",0xF0000);
 N_IRQ=MyIniFile->ReadInteger("misc","IRQ",10);
 E_Addr->Text = IntToHex(PhysAddr,8);
 UpIRQ->Position = (UCHAR) N_IRQ;
 L_IRQ->Caption = IntToStr(N_IRQ);
 HwCtrl->IRQNumber = (UCHAR) N_IRQ;

 GWrite->Cells[1][0]="PORT";
 GWrite->Cells[2][0]="VAL";
 GRead->Cells[1][0]="PORT";
 GRead->Cells[2][0]="VAL";
 MemoHex->Cells[0][0]="  ADDR";
 MemoHex->Cells[1][0]="             HEX";
 MemoHex->Cells[2][0]="     ASCII";

 for (i=1; i<=16; i++){
  GWrite->Cells[0][i]=IntToStr(i);
   GWrite->Cells[1][i]=MyIniFile->ReadString("PortW","Port"+IntToStr(i),"0000");
  GWrite->Cells[2][i]=MyIniFile->ReadString("Values","Val"+IntToStr(i),"00");
  GRead->Cells[0][i]=IntToStr(i);
  GRead->Cells[1][i]=MyIniFile->ReadString("PortR","Port"+IntToStr(i),"0000");
  GRead->Cells[2][i]="..";
 }

 delete MyIniFile;

}
//---------------------------------------------------------------------------
void __fastcall TForm1::B_WriteClick(TObject *Sender)
{
   PortWSel=(Word)HexToInt(GWrite->Cells[1][GWrite->Row]);
   GWrite->Cells[1][GWrite->Row]=IntToHex(PortWSel,4);
   ValWSel=(UCHAR)HexToInt(GWrite->Cells[2][GWrite->Row]);
   GWrite->Cells[2][GWrite->Row]=IntToHex(ValWSel,2);
   NomWSel=(Word)GWrite->Row;
   if (PortWSel==0) {MessageBeep(0); return;}
   HwCtrl->Port[PortWSel]=(UCHAR) ValWSel;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::B_ReadClick(TObject *Sender)
{
   PortRSel=(Word)HexToInt(GRead->Cells[1][GRead->Row]);
   GRead->Cells[1][GRead->Row]=IntToHex(PortRSel,4);
   NomRSel=(Word)GRead->Row;
   if (PortRSel==0) { MessageBeep(0); return; }
   GRead->Cells[2][GRead->Row]=IntToHex((int)HwCtrl->Port[PortRSel],2);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::B_ReadAllClick(TObject *Sender)
{
 UCHAR cl[17];
 Word  ports[17],P,N,i;

 N=0;
 for (i=1; i<=16; i++) {
   P=(Word)HexToInt(GRead->Cells[1][i]);
   GRead->Cells[1][i]=IntToHex(P,4);
   if(P) {ports[++N]=P; cl[N]=(UCHAR) i;}
 }
 for (i=1; i<=N; i++)
   GRead->Cells[2][cl[i]]=IntToHex((int)HwCtrl->Port[ports[i]],2);

}
//---------------------------------------------------------------------------
void __fastcall TForm1::B_WriteAllClick(TObject *Sender)
{
  Word i,P,V;
  for (i=1; i<=16; i++) {
    P=(Word)HexToInt(GWrite->Cells[1][i]); GWrite->Cells[1][i]=IntToHex(P,4);
    if (P) {
      V=(Word)HexToInt(GWrite->Cells[2][i]); GWrite->Cells[2][i]=IntToHex(V,2);
      HwCtrl->Port[P]=V;
    }
   }
}
//---------------------------------------------------------------------------
