/*
	------------------------------------------------------
	|Copyright (C) 1997 Michele PERNIOLA - TRANI (BA)	 |
	|Programmatore: Michele Perniola			         |
	|Procedura	  : victest - TVicHW32.dll test program	 |
	|Rel. 1.00	  : 20/12/95		                     |
	|Programma	  : victest.c              				 |
	|Rev. 1.00    : 05/07/97                             |
	|Descrizione  : Complete test program                |
	|							                         |
	------------------------------------------------------
*/

//----------------------------------------------------------------------------
// INCLUDE FILES
//----------------------------------------------------------------------------

#include <windows.h>
#include <stdio.h>

#include "resource.h"
#include "TVicHW32.h"

// functions declaration

int  WINAPI    WinMain(HANDLE, HANDLE, LPSTR, int);
LRESULT CALLBACK MainWndProc(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK	 MainDialogProc(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK    AboutDialogProc(HWND, UINT, WPARAM, LPARAM);

void ShowButtons(HWND hDlg);

HANDLE hInst;
HWND   hDlgMain = NULL;
DLGPROC lpAbtProc;

char AppName[] = "TVicHW32.DLL Test";      // Name of application
DWORD Flag_Intr = 0;
void* PointPhys = NULL;
DWORD PhysAddr = 0;
WORD  CurrIRQNumber = 10;

BYTE  membuffer[256];

HFONT	hFontMemdump = 0;
UINT  TimerID = 0;
DWORD Ticks = 0;


//----------------------------------------------------------------------------
DWORD
HexToInt(char* s)
{
	char hexch[] = "0123456789ABCDEF";
	int i,j;
   DWORD r,n,k;
   char ch;

  	k=1; r=0;
  	for (i=strlen(s);  i>0; i--) {
   	ch = s[i-1]; if (ch > 0x3f) ch &= 0xDF;
   	n = 0;
    	for (j = 0; j<16; j++)
      	if (ch == hexch[j])
         	n = j;
    	r += (n*k);
     	k *= 16;
	}
  	return r;
}


//----------------------------------------------------------------------------
char*
PrintMemLine(char *szBuf, LPSTR mem, int len, int dwid, DWORD olbl)
{
	int i, j;
	BYTE  c;
   BYTE  buff[80];
   BYTE  tbuf[80];

	if (len > dwid)
   	len = dwid;

	*szBuf = 0;

	// memory address
   sprintf((char *)tbuf, "%08X ", olbl);
   strcpy(szBuf, (char *)tbuf);

   for (i = 0; i < len; i++) {
   	c = *mem++;

       sprintf((char *)tbuf, "%02X", c);
       strcat(szBuf, (char *)tbuf);

       if (c >= 32 && c < 127)
       	buff[i] = c;
       else
       	buff[i] = 46;
    }

    j = dwid - i;

    buff[i] = 0;

    for (i = j; i > 0; i--)
        strcat(szBuf, "   ");

    // add ASCII codes.
    sprintf((char *)tbuf, " %s", (char *)buff);		// " |%s|"
    strcat(szBuf, (char *)tbuf);

    for (i = j; i > 0; i--)
        strcat(szBuf, " ");

    return(szBuf);
}



// ---------------------------------------------------------
// Hardware Interrupt Handler
// ---------------------------------------------------------
void
HWCtrlHwInterrupt()
{
	Flag_Intr ++;
}


//----------------------------------------------------------------------------
int WINAPI WinMain (HANDLE hInstance, HANDLE hPrevInstance,
															  LPSTR lpszCmdLine, int nCmdShow)
{
   MSG	  msg;
   HWND   hWnd;
   WNDCLASS wc;
   FARPROC lpfn;
   hInst = hInstance;

	wc.style = 0;
   wc.lpfnWndProc  = MainWndProc;
   wc.cbClsExtra   = 0;
   wc.cbWndExtra   = 0;
   wc.hInstance    = hInstance;
   wc.hIcon	   	 = LoadIcon (hInstance, MAKEINTRESOURCE(IDI_APPICON));
   wc.hCursor	    = LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground= (HBRUSH)COLOR_BACKGROUND;
   wc.lpszMenuName = NULL;
   wc.lpszClassName= "VictestWClass";

   if (!RegisterClass(&wc))
		return FALSE;

   hWnd = CreateWindow(
		  "VictestWClass",
		  AppName,
		  WS_OVERLAPPEDWINDOW|WS_CAPTION|WS_MINIMIZEBOX|WS_SYSMENU,
		  CW_USEDEFAULT,
		  CW_USEDEFAULT,//0,
		  CW_USEDEFAULT,//0,
		  CW_USEDEFAULT,//0,
        NULL,
        NULL,
        hInstance,
		  NULL);

   lpfn = MakeProcInstance(MainDialogProc, hInst);

   hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_MAINDIALOG), hWnd, lpfn);

   ShowWindow(hWnd, nCmdShow);
   ShowWindow(hDlgMain, SW_SHOW);

   while(GetMessage (&msg, NULL, 0, 0)) {

      if(hDlgMain == NULL || !IsDialogMessage(hDlgMain,&msg)) {
			TranslateMessage(&msg);
			DispatchMessage(&msg);
      }
   }
   return (msg.wParam);
}

//----------------------------------------------------------------------------
LRESULT CALLBACK MainWndProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
   switch (msg) {

      case WM_CREATE:
	 		break;

      case WM_COMMAND:
		   return (DefWindowProc(hWnd, msg, wParam, lParam));

      case WM_SETFOCUS:
         SetFocus(hDlgMain);
	 		break;

      case WM_DESTROY:
	 		PostQuitMessage(0);
	 		break;

     default:
			return (DefWindowProc(hWnd, msg, wParam, lParam));

   }
   return (0);
}


//----------------------------------------------------------------------------
BOOL CALLBACK MainDialogProc(HWND hDlg, UINT message,
													WPARAM wParam, LPARAM lParam)
{

   RECT rect;
   char buffer[256];
   int i;
   WORD a;
	BYTE d;

   switch (message) {

      case WM_INITDIALOG:

         GetWindowRect(hDlg, &rect);
         // center and resize window
         SetWindowPos(  GetParent(hDlg),
                     	NULL,
                     	(GetSystemMetrics(SM_CXSCREEN)-(rect.right-rect.left)) >> 1, // left
                     	(GetSystemMetrics(SM_CYSCREEN)-(rect.bottom-rect.top + GetSystemMetrics(SM_CYCAPTION))) >>1, // top
                     	rect.right-rect.left, 	// width
                     	rect.bottom-rect.top + GetSystemMetrics(SM_CYCAPTION), // height
                     	SWP_NOZORDER);

   		if ((GetVersion() & 0x80000000) != 0)
	   		SetDlgItemText(hDlg, IDE_SOTYPE, "95");
			else
				SetDlgItemText(hDlg, IDE_SOTYPE, "NT");

   		SendDlgItemMessage(hDlg, IDE_ADDR01, EM_LIMITTEXT, 4, 0L);
   		SendDlgItemMessage(hDlg, IDE_ADDR02, EM_LIMITTEXT, 4, 0L);
   		SendDlgItemMessage(hDlg, IDE_ADDR03, EM_LIMITTEXT, 4, 0L);
			SendDlgItemMessage(hDlg, IDE_ADDR04, EM_LIMITTEXT, 4, 0L);

   		SendDlgItemMessage(hDlg, IDE_DATA01, EM_LIMITTEXT, 2, 0L);
   		SendDlgItemMessage(hDlg, IDE_DATA02, EM_LIMITTEXT, 2, 0L);
   		SendDlgItemMessage(hDlg, IDE_DATA03, EM_LIMITTEXT, 2, 0L);
   		SendDlgItemMessage(hDlg, IDE_DATA04, EM_LIMITTEXT, 2, 0L);

   		// set defalut data
   		SetDlgItemInt(hDlg, IDE_ADDR01, 0, FALSE);
   		SetDlgItemInt(hDlg, IDE_ADDR02, 0, FALSE);
   		SetDlgItemInt(hDlg, IDE_ADDR03, 0, FALSE);
   		SetDlgItemInt(hDlg, IDE_ADDR04, 0, FALSE);

   		SetDlgItemInt(hDlg, IDE_DATA01, 0, FALSE);
   		SetDlgItemInt(hDlg, IDE_DATA02, 0, FALSE);
   		SetDlgItemInt(hDlg, IDE_DATA03, 0, FALSE);
   		SetDlgItemInt(hDlg, IDE_DATA04, 0, FALSE);

   		SetDlgItemInt(hDlg, IDE_IRQNUMBER, CurrIRQNumber, FALSE);
   		SendDlgItemMessage(hDlg, IDE_IRQNUMBER, EM_LIMITTEXT, 3, 0L);

   		//SendDlgItemMessage(IDC_UPDNIRQ, UDM_SETRANGE, 0, (LPARAM) MAKELONG( 255, 0));

        PhysAddr = 0xf0000;

   		sprintf(buffer, "%08X", PhysAddr);
   		SetDlgItemText(hDlg, IDE_MEMADDR, buffer);
		SetDlgItemText(hDlg, IDE_MEMADDR2, "????????");


//   		hFontMemdump = CreateFont(-14, 0, 0, 0, FW_NORMAL,
//    			0, 0, 0,  ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
//            DEFAULT_QUALITY, FIXED_PITCH | FF_DONTCARE, "Ms Sans Serif");
	   		hFontMemdump = CreateFont(-12, 0, 0, 0, FW_NORMAL,
   			0, 0, 0,  ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
            DEFAULT_QUALITY, FIXED_PITCH | FF_DONTCARE, "Courier New");

   		SendDlgItemMessage(hDlg, IDL_MEMDUMP, WM_SETFONT, (WPARAM)hFontMemdump, 0L);
		SendDlgItemMessage(hDlg, IDE_MEMADDR, WM_SETFONT, (WPARAM)hFontMemdump, 0L);
		SendDlgItemMessage(hDlg, IDE_MEMADDR2,WM_SETFONT, (WPARAM)hFontMemdump, 0L);

			TimerID = SetTimer(hDlg, 1000, 100, NULL);

			SetDlgItemInt(hDlg, IDE_IRQCOUNT  , 0, FALSE);
			SetDlgItemInt(hDlg, IDE_IRQHANDLED, 0, FALSE);
			SetDlgItemInt(hDlg, IDE_IRQTIME	 , 0, FALSE);

			ShowButtons(hDlg);

	 		return(TRUE);

      case WM_CLOSE:
			DestroyWindow(hDlg);
			hDlgMain = NULL;
			break;

		case WM_TIMER:
			if (wParam == TimerID) {

				if (IsDriverOpened() && IsIRQSet() && !IsMasked())
					Ticks ++;

				SetDlgItemInt(hDlg, IDE_IRQCOUNT	 , GetInterruptCounter(), FALSE);
				SetDlgItemInt(hDlg, IDE_IRQHANDLED, Flag_Intr, FALSE);
				SetDlgItemInt(hDlg, IDE_IRQTIME	 , Ticks / 10, FALSE);
			}
         break;

      case WM_COMMAND:
			switch (wParam) {
			   case IDB_DRIVER:
					if (IsDriverOpened()) {
						CloseTVicHW32();
				      PointPhys = NULL;
				   } else {
				   	if ( OpenTVicHW32() ) {
   						SetHardAccess( (bool)((SendDlgItemMessage(hDlg, IDC_HARD, BM_GETSTATE, 0, 0) & 1) != 0) );
			  			}  else {
				         MessageBox(hDlg, "Driver VICHWxx not found !", "Error",
                                MB_APPLMODAL | MB_OK | MB_ICONERROR);
						}
			   	}
   				ShowButtons(hDlg);
			      break;

            case IDB_SETMEM:
				   if (PointPhys != NULL) {
						UnmapMemory();
				   }
				   GetDlgItemText(hDlg, IDE_MEMADDR, buffer, 40);
				   PhysAddr = HexToInt(buffer);
				   sprintf(buffer, "%08X", PhysAddr);
				   SetDlgItemText(hDlg, IDE_MEMADDR, buffer);
				   PointPhys = MapPhysToLinear(PhysAddr, 256);
                   sprintf(buffer, "%08X", PointPhys);
				   SetDlgItemText(hDlg, IDE_MEMADDR2, buffer);
					ShowButtons(hDlg);
               break;

				case IDB_READMEM:
					if (PointPhys != NULL) {
				   	memcpy(membuffer, (BYTE*) PointPhys, 256);
	   				SendDlgItemMessage(hDlg, IDL_MEMDUMP, LB_RESETCONTENT, 0, 0);
      				for (i=0; i<16; i++) {
							PrintMemLine(buffer, (LPSTR) &membuffer[i*16], 16, 16, PhysAddr + (DWORD)(i*16));
		   				SendDlgItemMessage(hDlg, IDL_MEMDUMP, LB_ADDSTRING, 0, (LPARAM) (LPCTSTR)buffer);
				      }
					}
               break;

				case IDB_FILLMEM:
					if (PointPhys != NULL) {
				   	for (i=0; i<256; i++)
      					((BYTE*)PointPhys)[i] = (BYTE) i;
      				PostMessage(hDlg, WM_COMMAND, IDB_READMEM, 0);
					}
               break;

				case IDB_READ:
            	for (i=0; i<4; i++) {
						GetDlgItemText(hDlg, IDE_ADDR01 + i, buffer, 40);
                  a = (WORD) HexToInt(buffer);
					   sprintf(buffer, "%02X", ReadPort( a ));
					   SetDlgItemText(hDlg, IDE_DATA01 + i, buffer);
					}
               break;

				case IDB_WRITE:
            	for (i=0; i<4; i++) {
						GetDlgItemText(hDlg, IDE_ADDR01 + i, buffer, 40);
					   a = (WORD) HexToInt(buffer);
						GetDlgItemText(hDlg, IDE_DATA01 + i, buffer, 40);
   					d = (BYTE) HexToInt(buffer);
                  WritePort(a, d);
					}
               break;

            case IDC_HARD:
					SetHardAccess( (bool)((SendDlgItemMessage(hDlg, IDC_HARD, BM_GETSTATE, 0, 0) & 1) != 0) );
               break;

				case IDB_SETIRQ:
				   Flag_Intr = 0;
				  	Ticks = 0;
				 	if ( IsIRQSet()  )  {
				   	DestroyIRQ();
					} else {
				    	CurrIRQNumber = (WORD) GetDlgItemInt(hDlg, IDE_IRQNUMBER, NULL, FALSE);
				    	SetIRQ((BYTE)CurrIRQNumber, HWCtrlHwInterrupt);
   				}
				   ShowButtons(hDlg);
               break;

				case IDB_MASKIRQ:
					if (IsMasked()) {
				   	UnMaskIRQ();
				   } else {
						MaskIRQ();
				   }
					ShowButtons(hDlg);
               break;

				case IDB_SIMIRQ:
            	SimulateHWInt();
               break;

				case IDM_ABOUT:
					lpAbtProc = (DLGPROC) MakeProcInstance( (FARPROC) AboutDialogProc, hInst);
				   DialogBox(hInst, MAKEINTRESOURCE(IDD_ABOUTBOX), hDlgMain, lpAbtProc);
               break;

			   case IDM_EXIT:
              	PostMessage(GetParent(hDlg),WM_CLOSE, (WPARAM)0, (LPARAM)0);
	      		break;

	   		default:
	      		return (FALSE);
			}
			break;

		case WM_DESTROY:
        	if (TimerID)
		   	KillTimer(hDlg, TimerID);

			if (IsDriverOpened()) {
				CloseTVicHW32();
		   }

			if (hFontMemdump)
   			DeleteObject(hFontMemdump);

	 		return TRUE;

   }
	return (FALSE);
}


//----------------------------------------------------------------------------
void ShowButtons(HWND hDlg)
{
   //azzera la checkbox dell'accesso diretto
   SendDlgItemMessage(hDlg, IDC_HARD, BM_SETCHECK, (BOOL)TestHardAccess(), 0L);

	if (IsDriverOpened()) {
	   SendDlgItemMessage(hDlg, IDB_DRIVER, WM_SETTEXT, 0, (LPARAM)(LPCTSTR)"&Close Driver");
   } else {
   	SendDlgItemMessage(hDlg, IDB_DRIVER, WM_SETTEXT, 0, (LPARAM)(LPCTSTR)"&Open Driver");
	}

   EnableWindow(GetDlgItem(hDlg, IDB_READ)	, (BOOL) IsDriverOpened());
   EnableWindow(GetDlgItem(hDlg, IDB_WRITE)	, (BOOL) IsDriverOpened());
   EnableWindow(GetDlgItem(hDlg, IDB_SETMEM)	, (BOOL) IsDriverOpened());
   EnableWindow(GetDlgItem(hDlg, IDB_READMEM), (BOOL)(IsDriverOpened() && (PointPhys != NULL)));
   EnableWindow(GetDlgItem(hDlg, IDB_FILLMEM), (BOOL)(IsDriverOpened() && (PointPhys != NULL)));
   EnableWindow(GetDlgItem(hDlg, IDB_SETIRQ)	, (BOOL) IsDriverOpened());
   EnableWindow(GetDlgItem(hDlg, IDB_MASKIRQ), (BOOL)(IsDriverOpened() && IsIRQSet()));
   EnableWindow(GetDlgItem(hDlg, IDB_SIMIRQ)	, (BOOL)(IsDriverOpened() && IsIRQSet() && IsMasked()));

 	if ( IsIRQSet()  )  {
	   SendDlgItemMessage(hDlg, IDB_SETIRQ, WM_SETTEXT, 0, (LPARAM)(LPCTSTR)"&Destroy IRQ");
	} else {
	   SendDlgItemMessage(hDlg, IDB_SETIRQ, WM_SETTEXT, 0, (LPARAM)(LPCTSTR)"&Set IRQ");
   }

	if (IsMasked()) {
	   SendDlgItemMessage(hDlg, IDB_MASKIRQ, WM_SETTEXT, 0, (LPARAM)(LPCTSTR)"&Unmask IRQ");
   } else {
	   SendDlgItemMessage(hDlg, IDB_MASKIRQ, WM_SETTEXT, 0, (LPARAM)(LPCTSTR)"&Mask IRQ");
	}
}


//----------------------------------------------------------------------------
BOOL CALLBACK AboutDialogProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)													
{

	switch (message) {
		case WM_INITDIALOG:
      	return TRUE;

		case WM_SYSCOMMAND:
      	SendMessage(hDlgMain, message, wParam, lParam);
      	break;

		case WM_COMMAND:
      	EndDialog(hDlg, TRUE);
      	break;

  		default:
      	return FALSE;
	}

    return(TRUE);
}



//--------- END OF FILE  -----------------------------------------------------

