/// <summary>
/// Ansteuerung der PortDLL aus C#/dotNET
/// 
/// Diese Klasse ist ein sogenannter Wrapper um die PortDLL.
/// Sie importiert die Funktionen der DLL und stellt sie
/// als public Methoden zu Verfgung.
/// Hier sind nur die Funktionen eingebunden, die fr das
/// Beispiel gebraucht werden.
/// Natrlich knnte man die DLL-Funktionen auch direkt 
/// in ein Form importieren aber der Weg ber einen Wrapper 
/// ist eleganter, da er austauschbar und erweiterbar ist.
///
/// Der Source ist sicher nicht als Beispiel fr zeitgeme oder effiziente
/// Programmierung der Seriellen Schnittstelle unter C#/dotNET zu verstehen. 
/// Aber vielleicht hilft er dem einen oder anderen dabei weitere Programme
/// fr die PortDLL nach C# zu portieren, die tollen Sachen auf Burkhard
/// Kainkas Seite auszuprobieren oder einfach nur den ein oder anderen
/// Teil fr eigene Programme zu verwenden.
///
/// Der Source sollte sich mit Visual C# 2005 Express Edition oder
/// Visual Studio 2005 bersetzen lassen.
/// Die "port.dll" muss sich entweder im Windows Verzeichnis befinden
/// oder da wo die ausfhrbare Datei dieses Programmes liegt.
///  
/// Sourcen und Programm sind von mir fr die freie private Verwendung
/// freigegeben und unterliegen keinen Lizenzbedingungen,
/// auer dass ich weder die Haftung dafr bernehme noch fr
/// irgendeine Funktionalitt garantiere.
/// Die Benutzung erfolgt also auf eigene Gefahr!
///
/// Wer findet dass dieses Programm oder der Source in irgend einer Form
/// ntzlich ist, der kann mir ja eine Mail oder eine Postkarte 
/// schreiben. 
/// 
/// Also dann, viel Spa damit!
/// Sascha Bader
/// 
/// Weitere Informationen und/oder aktuellere Versionen sind
/// mit etwas Glck hier zu finden: http://www.sascha-bader.de/html/portdlldemo.html 
/// </summary>

using System;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace PortDLLDemo
{
  public class PortDLL
  {
    // dll imports    
    [DllImport("port.dll")]
    public static extern bool OPENCOM(string A);

    [DllImport("port.dll")]
    public static extern void CLOSECOM();

    // output functions
    [DllImport("port.dll")]
    public static extern void DTR(int B);

    [DllImport("port.dll")]
    public static extern void RTS(int B);

    [DllImport("port.dll")]
    public static extern void TXD(int B);

    [DllImport("port.dll")]
    public static extern void SENDBYTE(int B);

    // input functions
    [DllImport("port.dll")]
    public static extern int READBYTE();

    [DllImport("port.dll")]
    public static extern bool CTS();

    [DllImport("port.dll")]
    public static extern bool DSR();

    [DllImport("port.dll")]
    public static extern bool RI();

    [DllImport("port.dll")]
    public static extern bool DCD();

    // timing functions
    [DllImport("port.dll")]
    public static extern void DELAY(int B);

    [DllImport("port.dll")]
    public static extern void TIMEINIT();

    [DllImport("port.dll")]
    public static extern void TIMEINITUS();

    [DllImport("port.dll")]
    public static extern long TIMEREAD();

    [DllImport("port.dll")]
    public static extern long TIMEREADUS();

    [DllImport("port.dll")]
    public static extern void DELAYUS(long B);

    [DllImport("port.dll")]
    public static extern void REALTIME(bool B);
  }
}
