;  Ansteuerung eines FS20 Gertes, nur senden 
// --------------------------------------------------------------
// 
//  vom Rechner aus ber RS232
//  Schreiben   : 1 senden Rckgabe 1
//              : HC1  Adresse senden Rckgabe HC1
//              : Hc2  Adresse senden Rckgabe HC2
//		        : Adresse senden Rckgabe Adress
//		        : Kommando senden Rckgabe Kommando
//                Checksumme wird intern berechnet
//  Rckgabe	: 111 nach Abschluss

//  Kurzform mit hart codiertem Hauscode
//  Schreiben   : 2 senden Rckgabe 2
//                HC1 und HC2 vorgegeben
//		        : Adresse senden Rckgabe Adress
//		        : Kommando senden Rckgabe Kommando
//                Checksumme wird intern berechnet
//  Rckgabe	: 222 nach Abschluss
//
//  Testkommando 3 , dann mssen beide LED kurz blitzen

//  Testkommando 4:
//  Zum Test des Signals mit dem Oszillographen
//  sendet 1 1 1 1 mit checksum 6+4=10  , beachte chks startet mit 6
//  eventghost sollte mit FS20PCE.11121112.dodim6% antworten

//  Version 01 vom29.4.2010
//  noch einige Kontrollausgaben zum Debuggen
    


// todo
// Warum 6 wiederholungen?
// Rckgabe der Durchlufe nicht programmiert

			.include "tn13def.inc"

	.def   A      = r16
	.def   B      = r17
	.def   C      = r18
	.def   D      = r19
    .def   E      = r20
	.def   Count  = r21
    .def   Delay  = r22
    .def   loop01 = r23
	.def   loop10 = r24
	.def   Index  = r25
	


;Port B
    .equ   TXD       = 1
    .equ   RXD       = 2
    .equ   transmit  = 3	; PB3
    .equ   led       = 4  ; PB4
    


        rjmp Anfang
Anfang:
        sbi   	ddrb,TXD  ;Datenrichtung TXD
		sbi     ddrb,transmit
		sbi     ddrb,led
		
Schleife:
	 	rcall  	RdCom
		mov		Index,A				
	 	cpi		Index,1
	 	brne	K2

befSendeFS20:
		rcall	WrCom
		rcall	tueSendeFS20
		ldi     A,111
		rcall   WrCom    ; Kontrollausgabe  Befehl ausgefuehrt
		rjmp	Schleife
				
K2:		cpi		Index,2
		brne 	k3

kurzBefSendeFS20:
	 	rcall  	WrCom
     	rcall  	tuekurzBefSendeFS20
		ldi     A,222
		rcall   WrCom    ; Kontrollausgabe  Befehl ausgefuehrt
	  	rjmp   	Schleife

K3:		cpi		Index,3
		brne 	k4

irgendwas:
	 	rcall  	WrCom
     	rcall  	tueIrgendwas
	  	rjmp   	Schleife


K4:		cpi		Index,4
        brne 	kGroesser

testsignal:
        rcall   WrCom
		rcall   tuetestsignal
		rjmp    Schleife


Kgroesser:
		rcall	WrCom
		rjmp	Schleife

tuetestsignal: rcall fs20_sendsync   
                ldi A,1
                rcall fs20_send_byte
				ldi A,1
                rcall fs20_send_byte
				ldi A,1
                rcall fs20_send_byte
				ldi A,1
                rcall fs20_send_byte
				ldi A,10               ; beachte Checksumme faengt mit 6 an
                rcall fs20_send_byte
                rcall fs20_send_zero;
                rcall warte10ms

				rcall fs20_sendsync   
                ldi A,1
                rcall fs20_send_byte
				ldi A,1
                rcall fs20_send_byte
				ldi A,1
                rcall fs20_send_byte
				ldi A,1
                rcall fs20_send_byte
				ldi A,10
                rcall fs20_send_byte
                rcall fs20_send_zero;
                rcall warte10ms
				rcall fs20_sendsync   
                ldi A,1
                rcall fs20_send_byte
				ldi A,1
                rcall fs20_send_byte
				ldi A,1
                rcall fs20_send_byte
				ldi A,1
                rcall fs20_send_byte
				ldi A,10
                rcall fs20_send_byte
                rcall fs20_send_zero;
                rcall warte10ms
				ret

tueIrgendwas:   sbi portb,led  ; nur zum Testen kurz Blinken
                sbi portb,transmit
                rcall warte255
				cbi portb,transmit
				cbi portb,led
                ret

tuekurzBefSendeFS20:
                    ; Parameter von der RS232 lesen
			ldi     A,xxx                           ; testHC1, hier richtigen Wert eintragen
			mov     B,A			         ; HC1 nach B

			ldi     A,xxx                            ; Test HC2, hier richtigen Wert eintragen
			mov     C,A				                ; HC2 nach C

            rcall   RdCom
            mov     D,A           	                ; Adresse nach D
			rcall   WrCom
            rcall   RdCom  
            mov     E,A                             ; Befehl nach E
			rcall   WrCom

            ldi     XL,96                           ; Ram-Pointer vorbereiten
            ldi     XH,0
			mov     A,B
			st      X+,A                            ; HC1 sichern
            mov     A,C
			st      X+,A                            ; HC2 sichern
			mov     A,D
			st      X+,A                            ; Adresse sichern
			mov     A,E
			st      x+,A							; Befehl sichern
			                            
			rcall	SendeFS20Kommando		
			
       		        ret

tueSendeFS20:				; Parameter von der RS232 lesen
			rcall	RdCom
			mov     B,A			                    ; HC1 nach B
			rcall   WrCom
			rcall 	RDCom
			mov     C,A				                ; HC2 nach C
			rcall   WrCom
            rcall   RdCom
            mov     D,A           	                ; Adresse nach D
			rcall   WrCom
            rcall   RdCom  
            mov     E,A                             ; Befehl nach E
			rcall   WrCom

            ldi     XL,96                           ; Ram-Pointer vorbereiten
            ldi     XH,0
			mov     A,B
			st      X+,A                            ; HC1 sichern
            mov     A,C
			st      X+,A                            ; HC2 sichern
			mov     A,D
			st      X+,A                            ; Adresse sichern
			mov     A,E
			st      x+,A							; Befehl sichern
			                            
			rcall	SendeFS20Kommando		
			
       		        ret

SendeFS20Kommando:      ; die Parameter liegen auf im RAM ab 96 . HC1 , HC2, Adresse, Befehl
                        push E
						push D
						push A
                        sbi portb,led  ; LED einschalten nicht fuer Test, siehe fs20_SendOne
                        
                        ldi E,3        ; 3 mal wiederholen

sendeschleife:          rcall fs20_sendsync
                        mov A,E
                        //rcall WrCom  ; Kontrollausgabe Schleifenindex

                        ldi D,6        ; checksum faengt mit 6 an!!!
                        ldi XL,96      ; Ram pointer setzen
						ldi XH,0

						ld  A,X+       ; HC1 aus Ram
                        add D,A        ; checksumme erhoehen         
                        rcall fs20_send_byte ; HC1 senden

                        ld  A,X+       ; HC2 aus Ram
                        add D,A        ; checksumme erhoehen
                        rcall fs20_send_byte   ; HC2 senden

                        ld  A,X+       ; Adresse aus Ram       
                        add D,A        ; checksumme erhoehen
                        rcall fs20_send_byte   ; Adress senden

                        ld  A,X+       ; Befehl aus Ram
                        add D,A        ; checksumme erhoehen
                        rcall fs20_send_byte  ; Befehl senden

                        mov A,D
                        rcall fs20_send_byte  ; Checksumme senden
                        rcall fs20_send_zero;
                        
                        rcall warte10ms
						mov A,E
						
			            dec E
                        brne	sendeschleife
  
exitS:                  ; wird nur im Test benutzt
                        cbi portb,led  ; LED ausschalten
						pop A
						pop D
						pop E
                        ret



fs20_sendsync:		    rcall fs20_Send_zero
                        rcall fs20_Send_zero  
                        rcall fs20_Send_zero
                        rcall fs20_Send_zero
                        rcall fs20_Send_zero
                        rcall fs20_Send_zero  
                        rcall fs20_Send_zero
                        rcall fs20_Send_zero
                        rcall fs20_Send_zero
                        rcall fs20_Send_zero  
                        rcall fs20_Send_zero
                        rcall fs20_Send_zero
                        rcall fs20_Send_one
                        ret


fs20_send_byte:		; Wert in A erwartet
                       push     Count
					   push     C
					   push     D
					   push     A
			           ldi	   Count,8  		; Schleife ber 8 Bit
					   ldi     C,0              ; fuer Parityberechnung

schleife1:
			           sbrc	   A,7 		        ; Teste ob Bit 7 gesetzt ( im Ausgabewert)
            		   rjmp    Bit7on
			           rjmp    Bit7off
Bit7on:	               
                       ldi     D,1
					   eor     C,D
			           rcall   FS20_Send_One
			           rjmp	   clockit

Bit7off:		       ldi     D,0
					   eor     C,D              ; XOR mit E
			           rcall   fs20_Send_Zero
			           rjmp	   clockit
clockit:
			
			           lsl	   A   		    ; A Shiftleft
			           dec	   Count	  	; nachstes Bit
			           brne	   schleife1  	; alle Bits bearbeitet?

			           sbrc    C,0          ; Teste ob Paritiybit nicht gesetzt wird
					   rjmp    parityoff
					   rjmp    parityon
parityon:    
                       rcall   fs20_Send_zero
					   rjmp    paritydone

parityoff:
                       rcall  fs20_send_One
					   rjmp   paritydone
paritydone:
                       pop A
					   pop D
					   pop C
					   pop Count
					   ret


; sendet eine 1         fr den ersten Test ist es sinnvoll hier auch die led ein und auszuschalten
;                       dann kann man 0 und 1 unterscheiden wenn der Sender durch eine led ersetzt ist
fs20_Send_One:          
						; sbi     portb.led  ; beim Test
						sbi	      portb,transmit  
                        rcall     warte600us
                        cbi       portb,transmit
                        rcall     warte600us
						; cbi     portb,led   ; beim Test
						ret
; sende eine 0
fs20_Send_zero:
                        sbi	      portb,transmit
                        rcall     warte400us
                        cbi       portb,transmit
                        rcall     warte400us
                        ret      

warte400us:     rcall     warte01ms
                rcall     warte01ms
                rcall     warte01ms
                rcall     warte01ms
                ret

warte600us:     rcall     warte01ms
                rcall     warte01ms
                rcall     warte400us
                ret



; Warteschleife fr 0,1 ms = 100 microsec

warte01ms:
		ldi	Loop01, 17		; Beim Nachmessen mit dem Oszi sind es aber nur 17
L01:	;rcall warte255     ; lange Warteschleife bei Test um die Bits zu zaehlen
		nop          		; 1 Takt
		nop          		; 1 Takt
		nop			        ; 1 Takt
		dec	Loop01	        ; 1 Takt
		brne	L01			; 2 Takte also 6*20 = 120 Zyklen bei 1,2 MHz
		ret

; Warteschleife fr 10 ms

warte10ms:
		ldi Loop10,100
L10:
		rcall 	warte01ms
		dec   	Loop10
		brne  	L10
		ret




RdCOM:  sbis  pinb,RXD  ;Empfangen
        rjmp  RdCOM
        ldi   Delay,58  
D1:     dec   Delay
        brne  D1
        ldi   A,0
        ldi   Count,8
L1:     lsr   A
        sbic  pinb,RXD
        ori   A,128
        ldi   Delay, 38  
D2:     dec   Delay
        brne  D2
        dec   Count
        brne  L1
        ldi   Delay, 38
D3:     dec   Delay
        brne  D3
        com   A
        ret

WrCOM:  sbi   portb,TXD  ;Senden
        ldi   Delay,38 
D4:     dec   Delay
        brne  D4
        ldi   Count,8
L2:     sbrc  A,0
        rjmp  OFF
        rjmp  ON
ON :    sbi   portb,TXD
        rjmp  BitD
OFF:    cbi   portb,TXD
        rjmp  BitD
BitD:   ldi   Delay,38  
D5:     dec   Delay
        brne  D5
        lsr   A
        dec   Count
        brne  L2
        cbi   PORTB,TXD
        ldi   Delay,38  
D6:     dec   Delay
        brne  D6
        ret


// nur zum Testen 
warte255:						; zum Testen wartet zusaetzlich etwa 500ms
        push count
		ldi  count,255
L255:	rcall warte255innen
        dec  count
		brne L255
		pop  count
		ret
warte255innen:
        push index
		ldi  index,255
Li255:  
        rcall warte01ms
		dec index
        brne Li255
		pop  index
		ret


