unit Port8243;

interface

uses  PORTINC,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    RadioButton3: TRadioButton;
    RadioButton4: TRadioButton;
    RadioButton5: TRadioButton;
    RadioButton6: TRadioButton;
    RadioButton7: TRadioButton;
    RadioButton8: TRadioButton;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  end;

var
  Form1: TForm1;

const BA = $378;             { LPT1 }

implementation

{$R *.DFM}

procedure Setzen (Port_Nr,Wert: Byte);
var CS : Byte;
begin
  If (Port_Nr div 4)=0 then CS := 4;        { D1=CS1=0 }
  If (Port_Nr div 4)=1 then CS := 2;        { D2=CS2=0 }
  OutPort (BA, CS + 1);                     { D0=St=1 }
  OutPort (BA+2,((Port_Nr AND 3) + 4) XOR 11); { Steuerkommando }
  OutPort (BA, CS);                         { D0=St=0 }
  OutPort (BA+2, Wert XOR 11);              { Datenwort }
  OutPort (BA, CS + 1);                     { D0=St=1 }
  OutPort (BA, 6 + 1);                      { CS1=1, CS2=1 }
end;

function Lesen (Port_Nr : Byte): Byte;
var CS : Byte;
begin
  If (Port_Nr div 4)=0 then CS := 4;        { D1=CS1=0 }
  If (Port_Nr div 4)=1 then CS := 2;        { D2=CS2=0 }
  OutPort (BA, CS + 1);                     { D0=St=1 }
  OutPort (BA+2,(Port_Nr AND 3) XOR 11);    { Steuerkommando }
  OutPort (BA, CS);                         { D0=St=0 }
  OutPort (BA+2, 15 XOR 11);                { Bus hochohmig }
  Lesen := InPort(BA+2) AND 15 XOR 11;      { Daten lesen }
  OutPort (BA, CS + 1);                     { D0=St=1 }
  OutPort (BA, 6 + 1);                      { CS1=1, CS2=1 }
end;

procedure AND_Port (Port_Nr,Wert: Byte); var CS : Byte;
begin
  If (Port_Nr div 4)=0 then CS := 4;        { D1=CS1=0 }
  If (Port_Nr div 4)=1 then CS := 2;        { D2=CS2=0 }
  OutPort (BA, CS + 1);                     { D0=St=1 }
  OutPort (BA+2,((Port_Nr AND 3) + 12) XOR 11); { Steuerkommando }
  OutPort (BA, CS);                         { D0=St=0 }
  OutPort (BA+2, Wert XOR 11);              { Datenwort }
  OutPort (BA, CS + 1);                     { D0=St=1 }
  OutPort (BA, 6 + 1);                      { CS1=1, CS2=1 }
end;

procedure OR_PORT (Port_Nr,Wert: Byte);
var CS : Byte;
begin
  If (Port_Nr div 4)=0 then CS := 4;        { D1=CS1=0 }
  If (Port_Nr div 4)=1 then CS := 2;        { D2=CS2=0 }
  OutPort (BA, CS + 1);                     { D0=St=1 }
  OutPort (BA+2,((Port_Nr AND 3) + 8) XOR 11); { Steuerkommando }
  OutPort (BA, CS);                         { D0=St=0 }
  OutPort (BA+2, Wert XOR 11);              { Datenwort }
  OutPort (BA, CS + 1);                     { D0=St=1 }
  OutPort (BA, 6 + 1);                      { CS1=1, CS2=1 }
end;

Function Wert: Byte;
var Lesen: Byte;
begin
  Lesen := 0;
  if Form1.CheckBox1.Checked then Lesen := Lesen + 1;
  if Form1.CheckBox2.Checked then Lesen := Lesen + 2;
  if Form1.CheckBox3.Checked then Lesen := Lesen + 4;
  if Form1.CheckBox4.Checked then Lesen := Lesen + 8;
  Wert := Lesen;
end;

Function Port_Nr: Byte;
begin
  if Form1.RadioButton1.Checked Then Port_Nr := 0;
  if Form1.RadioButton2.Checked Then Port_Nr := 1;
  if Form1.RadioButton3.Checked Then Port_Nr := 2;
  if Form1.RadioButton4.Checked Then Port_Nr := 3;
  if Form1.RadioButton5.Checked Then Port_Nr := 4;
  if Form1.RadioButton6.Checked Then Port_Nr := 5;
  if Form1.RadioButton7.Checked Then Port_Nr := 6;
  if Form1.RadioButton8.Checked Then Port_Nr := 7;
end;


procedure TForm1.FormCreate(Sender: TObject);
begin
  OpenCom (Pchar('LPT1:'));
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Setzen (Port_Nr,Wert);
end;

procedure TForm1.Button2Click(Sender: TObject);
var Ergebnis: Byte;
begin
  Ergebnis :=Lesen (Port_Nr);
  CheckBox1.Checked := ((Ergebnis And 1) = 1);
  CheckBox2.Checked := ((Ergebnis And 2) = 2);
  CheckBox3.Checked := ((Ergebnis And 4) = 4);
  CheckBox4.Checked := ((Ergebnis And 8) = 8);
end;


procedure TForm1.Button3Click(Sender: TObject);
begin
  AND_Port (Port_Nr, Wert);
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  OR_Port (Port_Nr, Wert);
end;

end.
